/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.core.core.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import network.nerve.core.core.config.ConfigSetting;
import network.nerve.core.core.config.ConfigurationLoader;
import network.nerve.core.core.config.ModuleConfigParser;
import network.nerve.core.io.IoUtils;
import network.nerve.core.parse.JSONUtils;

public class JsonModuleConfigParser
implements ModuleConfigParser {
    @Override
    public String fileSuffix() {
        return "json";
    }

    @Override
    public Map<String, Map<String, ConfigurationLoader.ConfigItem>> parse(String configFile, InputStream inputStream) {
        try {
            String configJson = IoUtils.readRealPath(inputStream);
            Map<String, Object> data = JSONUtils.json2map(configJson);
            HashMap res = new HashMap(data.size());
            data.forEach((key, value) -> {
                if (ConfigSetting.isPrimitive(value.getClass())) {
                    res.put(key, new ConfigurationLoader.ConfigItem(configFile, String.valueOf(value)));
                } else {
                    try {
                        res.put(key, new ConfigurationLoader.ConfigItem(configFile, JSONUtils.obj2json(value)));
                    }
                    catch (JsonProcessingException e) {
                        e.printStackTrace();
                    }
                }
            });
            HashMap<String, Map<String, ConfigurationLoader.ConfigItem>> map = new HashMap<String, Map<String, ConfigurationLoader.ConfigItem>>();
            map.put("global", res);
            return map;
        }
        catch (Exception e) {
            throw new RuntimeException("json\u914d\u7f6e\u6587\u4ef6\u89e3\u6790\u9519\u8bef");
        }
    }
}

