/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.core.exception;

import java.text.MessageFormat;
import network.nerve.core.constant.ErrorCode;
import network.nerve.core.model.StringUtils;
import network.nerve.core.parse.I18nUtils;

public class NulsRuntimeException
extends RuntimeException {
    private String code;
    private String message;
    private ErrorCode errorCode;
    private static final String LANGUAGE = "en";
    private static final String LANGUAGE_PATH = "languages";

    public NulsRuntimeException(ErrorCode errorCode) {
        super(errorCode.getMsg());
        this.code = errorCode.getCode();
        this.message = errorCode.getMsg();
        this.errorCode = errorCode;
    }

    public NulsRuntimeException(ErrorCode errorCode, String message) {
        super(errorCode.getMsg());
        this.code = errorCode.getCode();
        this.message = errorCode.getMsg() + ";" + message;
        this.errorCode = errorCode;
    }

    public NulsRuntimeException(ErrorCode errorCode, Throwable cause) {
        super(errorCode.getMsg(), cause);
        this.code = errorCode.getCode();
        this.message = errorCode.getMsg();
        this.errorCode = errorCode;
    }

    public NulsRuntimeException(ErrorCode errorCode, String message, Throwable cause) {
        super(errorCode.getMsg(), cause);
        this.code = errorCode.getCode();
        this.message = errorCode.getMsg() + ":" + message;
        this.errorCode = errorCode;
    }

    public NulsRuntimeException(Throwable cause) {
        super(cause);
    }

    protected NulsRuntimeException(ErrorCode message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message.getMsg(), cause, enableSuppression, writableStackTrace);
        this.code = message.getCode();
        this.message = message.getMsg();
        this.errorCode = message;
    }

    @Override
    public String getMessage() {
        if (StringUtils.isBlank(this.message)) {
            return super.getMessage();
        }
        return this.message;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String format() {
        return MessageFormat.format("NulsRuntimeException -code: [{0}], -msg: {1}", this.code, this.message);
    }

    static {
        I18nUtils.loadLanguage(NulsRuntimeException.class, LANGUAGE_PATH, LANGUAGE);
    }
}

