/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.core.rpc.modulebootstrap;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import network.nerve.core.basic.InitializingBean;
import network.nerve.core.core.annotation.Autowired;
import network.nerve.core.core.annotation.Order;
import network.nerve.core.core.config.ConfigurationLoader;
import network.nerve.core.core.ioc.SpringLiteContext;
import network.nerve.core.exception.NulsException;
import network.nerve.core.log.Log;
import network.nerve.core.parse.I18nUtils;
import network.nerve.core.parse.MapUtils;
import network.nerve.core.rpc.model.ModuleE;
import network.nerve.core.rpc.model.message.Response;
import network.nerve.core.rpc.modulebootstrap.Module;
import network.nerve.core.rpc.modulebootstrap.ModuleStatusCmd;
import network.nerve.core.rpc.modulebootstrap.NotifySender;
import network.nerve.core.rpc.modulebootstrap.RegisterInvoke;
import network.nerve.core.rpc.modulebootstrap.RpcModuleState;
import network.nerve.core.rpc.netty.bootstrap.NettyServer;
import network.nerve.core.rpc.netty.channel.ConnectData;
import network.nerve.core.rpc.netty.channel.manager.ConnectManager;
import network.nerve.core.rpc.netty.processor.ResponseMessageProcessor;
import network.nerve.core.rpc.util.SetUtil;
import network.nerve.core.thread.ThreadUtils;

@Order(value=-2147483648)
public abstract class RpcModule
implements InitializingBean {
    private static final String LANGUAGE = "en";
    private static final String LANGUAGE_PATH = "languages";
    protected static final String ROLE = "1.0";
    private Set<Module> dependencies;
    private RpcModuleState state = RpcModuleState.Start;
    private Map<Module, Boolean> followerList = new ConcurrentHashMap<Module, Boolean>();
    private Map<Module, Boolean> dependentReadyState = new ConcurrentHashMap<Module, Boolean>();
    @Autowired
    NotifySender notifySender;

    public String toString() {
        return new StringJoiner(", ", RpcModule.class.getSimpleName() + "[", "]").add("dependencies=" + this.dependencies).add("state=" + (Object)((Object)this.state)).add("followerList=" + this.followerList).add("dependentReadyState=" + this.dependentReadyState).toString();
    }

    @Override
    public final void afterPropertiesSet() throws NulsException {
        try {
            String dependentList;
            this.dependencies = new HashSet<Module>();
            Module[] depend = this.declareDependent();
            if (depend != null) {
                this.dependencies.addAll(Arrays.asList(depend));
            }
            ConfigurationLoader configLoader = SpringLiteContext.getBean(ConfigurationLoader.class);
            String configDomain = this.moduleInfo().name;
            if (ModuleE.hasOfAbbr(this.moduleInfo().name)) {
                configDomain = ModuleE.valueOfAbbr((String)this.moduleInfo().getName()).name;
            }
            if ((dependentList = configLoader.getValue(configDomain, "dependent")) != null) {
                ConfigurationLoader.ConfigItem configItem = configLoader.getConfigItem(configDomain, "dependent");
                Log.info("{}.dependent : {} ==> {}[{}] ", this.getClass().getSimpleName(), dependentList, configItem.getConfigFile(), configDomain);
                String[] temp = dependentList.split(",");
                Arrays.stream(temp).forEach(ds -> this.dependencies.add(new Module((String)ds, ROLE)));
            }
            Log.info("module dependents:");
            this.dependencies.forEach(d -> Log.info("{}:{}", d.name, d.version));
            I18nUtils.loadLanguage(this.getClass(), this.getLanguagePath(), LANGUAGE);
            this.init();
        }
        catch (Exception e) {
            Log.error("rpc module init fail", e);
            throw new NulsException(e);
        }
    }

    void listenerDependenciesReady(Module module) {
        try {
            if (this.dependentReadyState.containsKey(module)) {
                if (this.dependentReadyState.get(module).equals(Boolean.TRUE)) {
                    return;
                }
                this.dependentReadyState.put(module, Boolean.TRUE);
            }
            Log.info("RMB:ModuleReadyListener :{}", module);
            this.tryRunModule();
            ConnectData connectData = ConnectManager.getConnectDataByRole(module.getName());
            connectData.addCloseEvent(() -> {
                if (!ConnectManager.ROLE_CHANNEL_MAP.containsKey(module.getName())) {
                    Log.warn("RMB:dependencie:{}\u6a21\u5757\u89e6\u53d1\u8fde\u63a5\u65ad\u5f00\u4e8b\u4ef6", module);
                    this.dependentReadyState.put(module, Boolean.FALSE);
                    if (this.followerList.containsKey(module)) {
                        this.followerList.remove(module);
                    }
                    if (this.isRunning()) {
                        this.state = this.onDependenciesLoss(module);
                        if (this.state == null) {
                            Log.error("onDependenciesReady return null state", new NullPointerException("onDependenciesReady return null state"));
                            System.exit(0);
                        }
                        Log.info("RMB:module state : {}", new Object[]{this.state});
                    }
                }
            });
            this.onDependenciesReady(module);
        }
        catch (Exception e) {
            Log.error("");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFollower(Module module) {
        RpcModule rpcModule = this;
        synchronized (rpcModule) {
            if (!this.followerList.containsKey(module)) {
                Log.info("RMB:registerModuleDependencies :{}", module);
                this.followerList.put(module, Boolean.FALSE);
                if (this.dependentReadyState.containsKey(module)) {
                    this.dependentReadyState.put(module, Boolean.FALSE);
                }
                try {
                    ConnectData connectData = ConnectManager.getConnectDataByRole(module.getName());
                    connectData.addCloseEvent(() -> {
                        if (!ConnectManager.ROLE_CHANNEL_MAP.containsKey(module.getName())) {
                            Log.warn("RMB:follower:{}\u6a21\u5757\u89e6\u53d1\u8fde\u63a5\u65ad\u5f00\u4e8b\u4ef6", module);
                            this.followerList.remove(module);
                        }
                    });
                    Log.debug("\u7ed1\u5b9a\u8fde\u63a5\u65ad\u5f00\u4e8b\u4ef6:{}", module.name);
                }
                catch (Exception e) {
                    Log.error("RMB:\u83b7\u53d6follower:{}\u6a21\u5757\u8fde\u63a5\u53d1\u751f\u5f02\u5e38.", module, e);
                }
            }
        }
        if (this.isReady()) {
            this.notifyFollowerReady(module);
        }
    }

    private void notifyFollowerReady(Module module) {
        this.notifySender.send("notifyFollowerReady_" + module.toString(), 10, () -> {
            try {
                Response cmdResp = ResponseMessageProcessor.requestAndResponse(module.getName(), "listenerDependenciesReady", MapUtils.beanToLinkedMap(this.moduleInfo()), 1000L);
                if (cmdResp.isSuccess()) {
                    this.followerList.put(module, Boolean.TRUE);
                    Log.info("notify follower {} is Ready success", module);
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                Log.error("Calling remote interface failed. module:{} - interface:{} - message:{}", module, "registerModuleDependencies", e.getMessage());
                return false;
            }
        });
    }

    private void notifyFollowerReady() {
        this.followerList.keySet().forEach(this::notifyFollowerReady);
    }

    void run(String modulePackage, String serviceManagerUrl) {
        this.getDependencies().forEach(d -> this.dependentReadyState.put((Module)d, Boolean.FALSE));
        try {
            TreeSet<String> scanCmdPackage = new TreeSet<String>();
            scanCmdPackage.add("io.nuls.core.rpc.cmd");
            scanCmdPackage.add("io.nuls.base.protocol.cmd");
            scanCmdPackage.addAll(this.getRpcCmdPackage() == null ? SetUtil.of(modulePackage) : this.getRpcCmdPackage());
            NettyServer server = NettyServer.getInstance(this.moduleInfo().getName(), this.moduleInfo().getName(), "Nuls").moduleRoles(new String[]{this.getRole()}).moduleVersion(this.moduleInfo().getVersion()).scanPackage(scanCmdPackage).addCmdDetail(ModuleStatusCmd.class);
            this.dependentReadyState.keySet().forEach(d -> server.dependencies(d.getName(), d.getVersion()));
            ConnectManager.getConnectByUrl(serviceManagerUrl);
            Log.info("RMB:\u5f00\u59cb\u8fde\u63a5service manager:{}", serviceManagerUrl);
            ResponseMessageProcessor.syncKernel(serviceManagerUrl, new RegisterInvoke(this.moduleInfo(), this.dependentReadyState.keySet()));
            while (!this.doStart()) {
                TimeUnit.SECONDS.sleep(10L);
            }
            Log.info("RMB:module is READY");
            this.state = RpcModuleState.Ready;
            this.notifyFollowerReady();
            this.tryRunModule();
        }
        catch (Exception e) {
            Log.error(this.moduleInfo().toString() + " initServer failed", e);
            System.exit(0);
        }
    }

    private synchronized void tryRunModule() {
        if (!this.isReady()) {
            return;
        }
        boolean dependencieReady = this.dependentReadyState.isEmpty();
        if (!dependencieReady) {
            dependencieReady = this.dependentReadyState.entrySet().stream().allMatch(Map.Entry::getValue);
        }
        if (dependencieReady) {
            if (!this.isRunning()) {
                Log.info("RMB:dependencie state");
                this.dependentReadyState.forEach((key, value) -> Log.debug("{}:{}", key.getName(), value));
                Log.info("RMB:module try running");
                CountDownLatch latch = new CountDownLatch(1);
                ThreadUtils.createAndRunThread("module running", () -> {
                    try {
                        this.state = this.onDependenciesReady();
                        if (this.state == null) {
                            Log.error("onDependenciesReady return null state", new NullPointerException("onDependenciesReady return null state"));
                            System.exit(0);
                        }
                    }
                    catch (Exception e) {
                        Log.error("RMB:try running module fail ", e);
                        System.exit(0);
                    }
                    latch.countDown();
                });
                try {
                    latch.await(this.getTryRuningTimeout(), TimeUnit.SECONDS);
                    if (this.state != RpcModuleState.Running) {
                        Log.error("RMB:module try running timeout");
                        System.exit(0);
                    }
                }
                catch (InterruptedException e) {
                    Log.error("wait module running fail");
                    System.exit(0);
                }
                Log.info("RMB:module state : " + (Object)((Object)this.state));
            }
        } else {
            Log.info("RMB:dependencie is not all ready");
            Log.info("RMB:dependencie state");
            this.dependentReadyState.forEach((key, value) -> Log.debug("{}:{}", key.getName(), value));
        }
    }

    protected long getTryRuningTimeout() {
        return 30L;
    }

    protected String getRole() {
        return ROLE;
    }

    protected boolean isRunning() {
        return this.state.getIndex() >= RpcModuleState.Running.getIndex();
    }

    protected boolean isReady() {
        return this.state.getIndex() >= RpcModuleState.Ready.getIndex();
    }

    public boolean isDependencieReady(Module module) {
        if (!this.dependentReadyState.containsKey(module)) {
            throw new IllegalArgumentException("can not found " + module.getName());
        }
        return this.dependentReadyState.get(module);
    }

    public boolean hasDependent(ModuleE moduleE) {
        return this.hasDependent(Module.build(moduleE));
    }

    public boolean hasDependent(Module module) {
        return this.getDependencies().stream().anyMatch(module::equals);
    }

    public boolean isDependencieReady(String moduleName) {
        return this.isDependencieReady(new Module(moduleName, ROLE));
    }

    protected boolean isDependencieReady() {
        return this.dependentReadyState.entrySet().stream().allMatch(d -> (Boolean)d.getValue());
    }

    public Set<Module> getDependencies() {
        return this.dependencies;
    }

    public abstract Module[] declareDependent();

    public Set<String> getRpcCmdPackage() {
        return null;
    }

    public abstract Module moduleInfo();

    public void onDependenciesReady(Module module) {
        Log.debug("dependentReadyState module {} ready", module);
    }

    public void init() {
        Log.info("module inited");
    }

    public abstract boolean doStart();

    public abstract RpcModuleState onDependenciesReady();

    public abstract RpcModuleState onDependenciesLoss(Module var1);

    protected String getLanguagePath() {
        return LANGUAGE_PATH;
    }

    public static String getROLE() {
        return ROLE;
    }

    public RpcModuleState getState() {
        return this.state;
    }

    public void setState(RpcModuleState state) {
        this.state = state;
    }

    public Map<Module, Boolean> getFollowerList() {
        return this.followerList;
    }

    public void setFollowerList(Map<Module, Boolean> followerList) {
        this.followerList = followerList;
    }

    public void setDependentReadyState(Map<Module, Boolean> dependentReadyState) {
        this.dependentReadyState = dependentReadyState;
    }

    public NotifySender getNotifySender() {
        return this.notifySender;
    }

    public void setNotifySender(NotifySender notifySender) {
        this.notifySender = notifySender;
    }
}

