/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.core.rpc.netty.bootstrap;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketClientCompressionHandler;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import network.nerve.core.log.Log;
import network.nerve.core.rpc.netty.handler.ClientHandler;
import network.nerve.core.rpc.netty.processor.ResponseMessageProcessor;

public class NettyClient {
    public static Channel createConnect(String uri) {
        return NettyClient.createConnect(uri, 0);
    }

    public static Channel createConnect(String uri, int tryCount) {
        try {
            URI webSocketURI = null;
            try {
                webSocketURI = new URI(uri);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            final ClientHandler handler = new ClientHandler(WebSocketClientHandshakerFactory.newHandshaker((URI)webSocketURI, (WebSocketVersion)WebSocketVersion.V13, null, (boolean)true, (HttpHeaders)new DefaultHttpHeaders(), (int)0x6800000));
            NioEventLoopGroup group = new NioEventLoopGroup();
            Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)b.group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(0x6800000), WebSocketClientCompressionHandler.INSTANCE, handler});
                }
            });
            Channel ch = b.connect(webSocketURI.getHost(), webSocketURI.getPort()).sync().channel();
            handler.handshakeFuture().sync();
            ResponseMessageProcessor.handshake(ch);
            return ch;
        }
        catch (Exception e) {
            if (tryCount < 5) {
                try {
                    TimeUnit.SECONDS.sleep(3L);
                }
                catch (InterruptedException e1) {
                    Log.error("\u91cd\u8bd5ws\u8fde\u63a5\u65f6\uff0c\u4f11\u7720\u8fdb\u7a0b\u53d1\u751f\u5f02\u5e38");
                }
                Log.info("\u521b\u5efaws:{}\u5931\u8d25\uff0c\u7b2c{}\u91cd\u8bd5", uri, tryCount + 1);
                return NettyClient.createConnect(uri, tryCount + 1);
            }
            Log.error("\u521b\u5efaws\u8fde\u63a5\u5931\u8d25\uff1a{}", uri, e);
            return null;
        }
    }
}

