/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.core.rpc.netty.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.util.Map;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import network.nerve.core.log.Log;
import network.nerve.core.parse.JSONUtils;
import network.nerve.core.rpc.info.Constants;
import network.nerve.core.rpc.model.CmdPriority;
import network.nerve.core.rpc.model.message.Message;
import network.nerve.core.rpc.model.message.MessageType;
import network.nerve.core.rpc.model.message.Request;
import network.nerve.core.rpc.netty.channel.manager.ConnectManager;
import network.nerve.core.rpc.netty.handler.message.TextMessageHandler;
import network.nerve.core.thread.commom.NulsThreadFactory;

public class ServerHandler
extends SimpleChannelInboundHandler<Object> {
    private ThreadPoolExecutor requestExecutorService = new ThreadPoolExecutor(Constants.THREAD_POOL_SIZE, Constants.THREAD_POOL_SIZE, 0L, TimeUnit.MILLISECONDS, new PriorityBlockingQueue<Runnable>(), new NulsThreadFactory("server-handler-request"));
    private ThreadPoolExecutor responseExecutorService = new ThreadPoolExecutor(Constants.THREAD_POOL_SIZE, Constants.THREAD_POOL_SIZE, 0L, TimeUnit.MILLISECONDS, new PriorityBlockingQueue<Runnable>(), new NulsThreadFactory("server-handler-request"));

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof TextWebSocketFrame) {
            TextWebSocketFrame txMsg = (TextWebSocketFrame)msg;
            ByteBuf content = txMsg.content();
            byte[] bytes = new byte[content.readableBytes()];
            content.readBytes(bytes);
            Message message = JSONUtils.byteArray2pojo(bytes, Message.class);
            MessageType messageType = MessageType.valueOf(message.getMessageType());
            int priority = CmdPriority.DEFAULT.getPriority();
            TextMessageHandler messageHandler = new TextMessageHandler((SocketChannel)ctx.channel(), message, priority);
            if (this.requestExecutorService.getQueue().size() >= 500 || this.responseExecutorService.getQueue().size() > 500) {
                String role = ConnectManager.getRoleByChannel(ctx.channel());
                Log.info("\u94fe\u63a5{}\u5f53\u524d\u8bf7\u6c42\u7ebf\u7a0b\u6c60\u603b\u7ebf\u7a0b\u6570\u91cf{},\u8fd0\u884c\u4e2d\u7ebf\u7a0b\u6570\u91cf{},\u7b49\u5f85\u961f\u5217\u6570\u91cf{}", role, this.requestExecutorService.getPoolSize(), this.requestExecutorService.getActiveCount(), this.requestExecutorService.getQueue().size());
                Log.info("\u94fe\u63a5{}\u5f53\u524d\u54cd\u5e94\u7ebf\u7a0b\u6c60\u603b\u7ebf\u7a0b\u6570\u91cf{},\u8fd0\u884c\u4e2d\u7ebf\u7a0b\u6570\u91cf{},\u7b49\u5f85\u961f\u5217\u6570\u91cf{}", role, this.responseExecutorService.getPoolSize(), this.responseExecutorService.getActiveCount(), this.responseExecutorService.getQueue().size());
            }
            if (messageType.equals((Object)MessageType.Response) || messageType.equals((Object)MessageType.NegotiateConnectionResponse) || messageType.equals((Object)MessageType.Ack)) {
                this.responseExecutorService.execute(messageHandler);
            } else {
                if (messageType.equals((Object)MessageType.Request)) {
                    Request request = JSONUtils.map2pojo((Map)message.getMessageData(), Request.class);
                    if (request.getRequestMethods().size() == 1) {
                        for (String cmd : request.getRequestMethods().keySet()) {
                            if (!ConnectManager.CMD_PRIORITY_MAP.containsKey(cmd)) continue;
                            messageHandler.setPriority(ConnectManager.CMD_PRIORITY_MAP.get(cmd));
                        }
                    }
                    messageHandler.setRequest(request);
                }
                this.requestExecutorService.execute(messageHandler);
            }
        } else {
            Log.warn("Unsupported message format");
        }
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ConnectManager.disConnect((SocketChannel)ctx.channel());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
        cause.printStackTrace();
    }
}

