/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.core.rpc.netty.thread;

import network.nerve.core.log.Log;
import network.nerve.core.rpc.model.message.Message;
import network.nerve.core.rpc.model.message.Request;
import network.nerve.core.rpc.netty.channel.ConnectData;
import network.nerve.core.rpc.netty.processor.RequestMessageProcessor;

public class RequestByPeriodProcessor
implements Runnable {
    private ConnectData connectData;

    public RequestByPeriodProcessor(ConnectData connectData) {
        this.connectData = connectData;
    }

    @Override
    public void run() {
        while (this.connectData.isConnected()) {
            try {
                if (!this.connectData.getRequestPeriodLoopQueue().isEmpty()) {
                    this.sendPeriodQueue();
                }
                Thread.sleep(6000L);
            }
            catch (Exception e) {
                Log.error(e);
            }
        }
    }

    private void sendPeriodQueue() {
        Request request;
        Object[] objects = this.connectData.getRequestPeriodLoopQueue().poll();
        Message message = (Message)objects[0];
        boolean isContinue = RequestMessageProcessor.responseWithPeriod(this.connectData, message, request = (Request)objects[1]);
        if (isContinue) {
            this.connectData.getRequestPeriodLoopQueue().offer(objects);
        }
    }
}

