/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.core.rpc.netty.thread;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import network.nerve.core.rpc.info.HostInfo;
import network.nerve.core.rpc.netty.initializer.ServerInitializer;

public class StartServerProcessor
implements Runnable {
    private static final String PATH = "/ws";
    private int port;
    private String path;
    private String host;

    public StartServerProcessor(int port) {
        this.port = port;
        this.path = PATH;
        this.host = HostInfo.getLocalIP();
    }

    public StartServerProcessor(int port, String host, String path) {
        this.port = port;
        this.path = path;
        this.host = host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap serverBootstrap = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)serverBootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).childHandler((ChannelHandler)new ServerInitializer(this.path));
            ChannelFuture channelFuture = serverBootstrap.bind((SocketAddress)new InetSocketAddress(this.host, this.port)).sync();
            channelFuture.channel().closeFuture().sync();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            bossGroup.shutdownGracefully();
            workerGroup.shutdownGracefully();
        }
    }
}

