/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.core.rpc.util;

import java.util.Map;
import network.nerve.core.exception.NulsException;
import network.nerve.core.log.Log;
import network.nerve.core.parse.JSONUtils;
import network.nerve.core.rpc.model.message.Response;
import network.nerve.core.rpc.netty.processor.ResponseMessageProcessor;

public class RpcCall {
    public static Object request(String moduleCode, String cmd, Map params) throws NulsException {
        return RpcCall.request(moduleCode, cmd, params, null);
    }

    public static Object request(String moduleCode, String cmd, Map params, Long timeout) throws NulsException {
        try {
            params.put("version", "1.0");
            Response cmdResp = null == timeout ? ResponseMessageProcessor.requestAndResponse(moduleCode, cmd, params) : ResponseMessageProcessor.requestAndResponse(moduleCode, cmd, params, timeout);
            Map resData = (Map)cmdResp.getResponseData();
            if (!cmdResp.isSuccess()) {
                String errorMsg;
                Log.error("response error info is {}", cmdResp);
                if (null == resData) {
                    errorMsg = String.format("Remote call fail. ResponseComment: %s ", cmdResp.getResponseComment());
                } else {
                    Map map = (Map)resData.get(cmd);
                    errorMsg = String.format("Remote call fail. msg: %s - code: %s - module: %s - interface: %s \n- params: %s ", map.get("msg"), map.get("code"), moduleCode, cmd, JSONUtils.obj2PrettyJson(params));
                }
                throw new Exception(errorMsg);
            }
            return resData.get(cmd);
        }
        catch (Exception e) {
            Log.debug("cmd: {}", cmd);
            throw new NulsException(e);
        }
    }
}

