/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.base.data;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import network.nerve.base.basic.AddressTool;
import network.nerve.base.basic.NulsByteBuffer;
import network.nerve.base.basic.NulsOutputStreamBuffer;
import network.nerve.base.data.BaseNulsData;
import network.nerve.base.data.CoinData;
import network.nerve.base.data.CoinFrom;
import network.nerve.base.data.CoinTo;
import network.nerve.base.data.NulsHash;
import network.nerve.core.constant.CommonCodeConstanst;
import network.nerve.core.constant.ToolsConstant;
import network.nerve.core.constant.TxStatusEnum;
import network.nerve.core.crypto.HexUtil;
import network.nerve.core.crypto.UnsafeByteArrayOutputStream;
import network.nerve.core.exception.NulsException;
import network.nerve.core.log.Log;
import network.nerve.core.model.DateUtils;
import network.nerve.core.parse.SerializeUtils;

public class Transaction
extends BaseNulsData
implements Cloneable {
    private int type;
    private byte[] coinData;
    private byte[] txData;
    private long time;
    private byte[] transactionSignature;
    private byte[] remark;
    private transient NulsHash hash;
    private transient long blockHeight = -1L;
    private transient TxStatusEnum status = TxStatusEnum.UNCONFIRM;
    private transient int size;
    private transient CoinData coinDataInstance;
    private int inBlockIndex;

    public Transaction() {
    }

    public Transaction(int type) {
        this.type = type;
    }

    @Override
    public int size() {
        int size = 0;
        size += SerializeUtils.sizeOfUint16();
        size += SerializeUtils.sizeOfUint32();
        size += SerializeUtils.sizeOfBytes(this.remark);
        size += SerializeUtils.sizeOfBytes(this.txData);
        size += SerializeUtils.sizeOfBytes(this.coinData);
        return size += SerializeUtils.sizeOfBytes(this.transactionSignature);
    }

    @Override
    public void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeUint16(this.type);
        stream.writeUint32(this.time);
        stream.writeBytesWithLength(this.remark);
        stream.writeBytesWithLength(this.txData);
        stream.writeBytesWithLength(this.coinData);
        stream.writeBytesWithLength(this.transactionSignature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] serializeForHash() throws IOException {
        try (ByteArrayOutputStream bos = null;){
            int size = this.size() - SerializeUtils.sizeOfBytes(this.transactionSignature);
            bos = new UnsafeByteArrayOutputStream(size);
            NulsOutputStreamBuffer buffer = new NulsOutputStreamBuffer(bos);
            if (size == 0) {
                bos.write(ToolsConstant.PLACE_HOLDER);
            } else {
                buffer.writeUint16(this.type);
                buffer.writeUint32(this.time);
                buffer.writeBytesWithLength(this.remark);
                buffer.writeBytesWithLength(this.txData);
                buffer.writeBytesWithLength(this.coinData);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    @Override
    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.type = byteBuffer.readUint16();
        this.time = byteBuffer.readUint32();
        this.remark = byteBuffer.readByLengthByte();
        this.txData = byteBuffer.readByLengthByte();
        this.coinData = byteBuffer.readByLengthByte();
        this.transactionSignature = byteBuffer.readByLengthByte();
    }

    public byte[] getTxData() {
        return this.txData;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public byte[] getRemark() {
        return this.remark;
    }

    public void setRemark(byte[] remark) {
        this.remark = remark;
    }

    public NulsHash getHash() {
        if (this.hash == null) {
            try {
                this.hash = NulsHash.calcHash(this.serializeForHash());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.hash;
    }

    public void setHash(NulsHash hash) {
        this.hash = hash;
    }

    public byte[] getTransactionSignature() {
        return this.transactionSignature;
    }

    public void setTransactionSignature(byte[] transactionSignature) {
        this.transactionSignature = transactionSignature;
    }

    public void setTxData(byte[] txData) {
        this.txData = txData;
    }

    public long getBlockHeight() {
        return this.blockHeight;
    }

    public void setBlockHeight(long blockHeight) {
        this.blockHeight = blockHeight;
    }

    public TxStatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(TxStatusEnum status) {
        this.status = status;
    }

    public byte[] getCoinData() {
        return this.coinData;
    }

    public int getInBlockIndex() {
        return this.inBlockIndex;
    }

    public void setInBlockIndex(int inBlockIndex) {
        this.inBlockIndex = inBlockIndex;
    }

    public CoinData getCoinDataInstance() throws NulsException {
        if (null == this.coinData || this.coinData.length == 0) {
            return null;
        }
        if (this.coinDataInstance == null) {
            this.coinDataInstance = new CoinData();
            this.coinDataInstance.parse(new NulsByteBuffer(this.coinData));
        }
        return this.coinDataInstance;
    }

    public void setCoinData(byte[] coinData) {
        this.coinData = coinData;
    }

    public int getSize() {
        if (this.size == 0) {
            this.size = this.size();
        }
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public static Transaction getInstance(byte[] txBytes) throws NulsException {
        NulsByteBuffer nulsByteBuffer = new NulsByteBuffer(txBytes);
        Transaction transaction = new Transaction();
        transaction.parse(nulsByteBuffer);
        return transaction;
    }

    public BigInteger getFee() throws NulsException {
        CoinData cData;
        BigInteger fee = BigInteger.ZERO;
        if (null != this.coinData && this.type > 1 && (cData = this.getCoinDataInstance()).getFrom().size() > 0) {
            BigInteger toAmount = BigInteger.ZERO;
            for (CoinTo coinTo : cData.getTo()) {
                toAmount = toAmount.add(coinTo.getAmount());
            }
            BigInteger fromAmount = BigInteger.ZERO;
            for (CoinFrom coinFrom : cData.getFrom()) {
                fromAmount = fromAmount.add(coinFrom.getAmount());
            }
            fee = fromAmount.subtract(toAmount);
        }
        return fee;
    }

    public boolean isMultiSignTx() throws NulsException {
        if (null == this.coinData) {
            return false;
        }
        CoinData cData = this.getCoinDataInstance();
        List<CoinFrom> from = cData.getFrom();
        if (from == null || from.size() == 0) {
            return false;
        }
        CoinFrom coinFrom = from.get(0);
        return AddressTool.isMultiSignAddress(coinFrom.getAddress());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Transaction)) {
            return false;
        }
        return this.getHash().equals(((Transaction)obj).getHash());
    }

    public int hashCode() {
        int result = this.type;
        result = 31 * result + Arrays.hashCode(this.coinData);
        result = 31 * result + Arrays.hashCode(this.txData);
        result = 31 * result + (int)(this.time ^ this.time >>> 32);
        result = 31 * result + Arrays.hashCode(this.transactionSignature);
        result = 31 * result + Arrays.hashCode(this.remark);
        return result;
    }

    public String format() throws Exception {
        return this.format(null);
    }

    public String format(Class txDataClasz) throws NulsException {
        StringBuilder builder = new StringBuilder();
        try {
            String lineSeparator = System.lineSeparator();
            builder.append(lineSeparator).append("*********************** Transaction information ***********************").append(lineSeparator);
            builder.append(String.format("type: %s", this.type)).append(lineSeparator);
            builder.append(String.format("txHash: %s", this.getHash().toHex())).append(lineSeparator);
            builder.append(String.format("time: %s", this.getTime())).append(lineSeparator);
            builder.append(String.format("time(format): %s", DateUtils.timeStamp2DateStr(this.getTime() * 1000L))).append(lineSeparator);
            builder.append(String.format("size: %s byte,", String.valueOf(this.getSize()))).append(lineSeparator);
            byte[] remark = this.getRemark();
            String remarkStr = remark == null ? null : new String(this.getRemark(), "UTF-8");
            builder.append(String.format("remark: %s", remarkStr)).append(lineSeparator);
            CoinData coinData = null;
            if (this.getCoinData() != null) {
                coinData = this.getCoinDataInstance();
                builder.append("coinData:").append(lineSeparator).append(coinData.toString());
            } else {
                builder.append("coinData: null").append(lineSeparator);
            }
            if (null != txDataClasz) {
                if (null != this.txData && this.txData.length != 0) {
                    try {
                        String txDataStr = Transaction.getInstance(this.txData, txDataClasz).toString();
                        builder.append("txData:").append(lineSeparator).append(txDataStr).append(lineSeparator);
                    }
                    catch (Exception e) {
                        Log.error("format txData error", e);
                    }
                } else {
                    builder.append("txData: null").append(lineSeparator);
                }
            } else if (null != this.txData && this.txData.length != 0) {
                builder.append("txData hex: ").append(HexUtil.encode(this.txData)).append(lineSeparator);
            } else {
                builder.append("txData: null").append(lineSeparator);
            }
            builder.append("***********************************************************************").append(lineSeparator);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new NulsException(e);
        }
        return builder.toString();
    }

    public static <T> T getInstance(byte[] bytes, Class<? extends BaseNulsData> clazz) throws Exception {
        if (null == bytes || bytes.length == 0) {
            throw new Exception(CommonCodeConstanst.DESERIALIZE_ERROR.getMsg());
        }
        try {
            BaseNulsData baseNulsData = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            baseNulsData.parse(new NulsByteBuffer(bytes));
            return (T)baseNulsData;
        }
        catch (Exception e) {
            throw new Exception(CommonCodeConstanst.DESERIALIZE_ERROR.getMsg());
        }
    }
}

