/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.base.signture;

import java.io.IOException;
import network.nerve.base.basic.NulsByteBuffer;
import network.nerve.base.basic.NulsOutputStreamBuffer;
import network.nerve.base.data.BaseNulsData;
import network.nerve.base.data.NulsHash;
import network.nerve.base.data.NulsSignData;
import network.nerve.core.basic.Result;
import network.nerve.core.crypto.ECKey;
import network.nerve.core.exception.NulsException;
import network.nerve.core.parse.SerializeUtils;

public class BlockSignature
extends BaseNulsData {
    private NulsSignData signData;
    private byte[] publicKey;

    @Override
    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.write(this.publicKey.length);
        stream.write(this.publicKey);
        stream.writeNulsData(this.signData);
    }

    @Override
    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        byte length = byteBuffer.readByte();
        this.publicKey = byteBuffer.readBytes(length);
        this.signData = new NulsSignData();
        this.signData.parse(byteBuffer);
    }

    @Override
    public int size() {
        int size = 1 + this.publicKey.length;
        return size += SerializeUtils.sizeOfNulsData(this.signData);
    }

    public Result verifySignature(NulsHash digestData) {
        boolean b = ECKey.verify(digestData.getBytes(), this.signData.getSignBytes(), this.publicKey);
        if (b) {
            return new Result(true);
        }
        return new Result(false);
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(byte[] publicKey) {
        this.publicKey = publicKey;
    }

    public NulsSignData getSignData() {
        return this.signData;
    }

    public void setSignData(NulsSignData signData) {
        this.signData = signData;
    }
}

