/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.core.basic;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import network.nerve.core.constant.CommonCodeConstanst;
import network.nerve.core.constant.ErrorCode;
import network.nerve.core.model.StringUtils;
import network.nerve.core.parse.JSONUtils;

public class Result<T>
implements Serializable {
    private boolean success;
    private String msg;
    private ErrorCode errorCode;
    private T data;

    public Result(boolean success) {
        this.success = success;
    }

    public Result(boolean success, T data) {
        this.success = success;
        this.data = data;
    }

    public Result(boolean success, ErrorCode errorCode, T data) {
        this.success = success;
        this.errorCode = errorCode;
        this.data = data;
    }

    public Result(boolean success, ErrorCode errorCode) {
        this.success = success;
        this.errorCode = errorCode;
    }

    public Result(boolean success, String msg) {
        this.success = success;
        this.msg = msg;
    }

    public boolean isSuccess() {
        return this.success;
    }

    @JsonIgnore
    public boolean isFailed() {
        return !this.success;
    }

    public Result<T> setSuccess(boolean success) {
        this.success = success;
        return this;
    }

    public String getMsg() {
        if (StringUtils.isBlank(this.msg)) {
            return this.errorCode.getMsg();
        }
        return this.msg;
    }

    public Result<T> setMsg(String msg) {
        this.msg = msg;
        return this;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(ErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("result:{");
        buffer.append("\"success\": ").append(this.success).append(",");
        buffer.append("\"msg\": \"").append(this.msg).append("\",");
        if (this.errorCode == null) {
            buffer.append("\"errorCode\": \"\",");
        } else {
            buffer.append("\"errorCode\": \"").append(this.errorCode.getCode()).append("\",");
        }
        if (this.data != null) {
            try {
                buffer.append("\"entity\":").append(JSONUtils.obj2json(this.data));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        buffer.append("}");
        return buffer.toString();
    }

    public static Result getSuccess(ErrorCode successCode) {
        return new Result(true, successCode);
    }

    public static <T> Result getSuccess(T t) {
        return new Result<T>(true, CommonCodeConstanst.SUCCESS, t);
    }

    public static Result getFailed(ErrorCode errorCode) {
        return new Result<Object>(false, errorCode, null);
    }

    public T getData() {
        return this.data;
    }

    public Result<T> setData(T data) {
        this.data = data;
        return this;
    }
}

