/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.core.parse;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import network.nerve.core.constant.ToolsConstant;
import network.nerve.core.exception.NulsException;
import network.nerve.core.log.Log;
import network.nerve.core.model.StringUtils;

public class I18nUtils {
    private static final Map<String, Properties> ALL_MAPPING = new HashMap<String, Properties>();
    private static Properties nowMapping = null;
    private static String key = "en";
    private static final String FOLDER = "common-languages";

    public static boolean isSystemWin() {
        String unixPathSeparator = ":";
        String pathSeparator = System.getProperty("path.separator");
        return !unixPathSeparator.equals(pathSeparator);
    }

    public static void loadCommonLanguage(String defaultLanguage) {
        ALL_MAPPING.clear();
        I18nUtils.load(I18nUtils.class, FOLDER, defaultLanguage);
    }

    public static void loadLanguage(Class c, String folder, String defaultLanguage) {
        ALL_MAPPING.clear();
        I18nUtils.load(I18nUtils.class, FOLDER, defaultLanguage);
        I18nUtils.load(c, folder, defaultLanguage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load(Class c, String folder, String defaultLanguage) {
        block32: {
            InputStream in = null;
            try {
                URL furl;
                if (StringUtils.isBlank(folder)) {
                    folder = FOLDER;
                }
                if (StringUtils.isNotBlank(defaultLanguage)) {
                    key = defaultLanguage;
                }
                if ((furl = I18nUtils.class.getClassLoader().getResource(folder)) == null) {
                    Log.warn("language folder not exists");
                    return;
                }
                if (null == furl) break block32;
                File folderFile = new File(furl.getPath());
                Log.info("furl.getPath()=" + furl.getPath());
                if (null != folderFile && null != folderFile.listFiles()) {
                    for (File file : folderFile.listFiles()) {
                        FileInputStream is = new FileInputStream(file);
                        Properties prop = new Properties();
                        prop.load(new InputStreamReader((InputStream)is, ToolsConstant.DEFAULT_ENCODING));
                        String key = file.getName().replace(".properties", "");
                        Log.info("key[0]={}", key);
                        if (ALL_MAPPING.containsKey(key)) {
                            ALL_MAPPING.get(key).putAll((Map<?, ?>)prop);
                            continue;
                        }
                        ALL_MAPPING.put(key, prop);
                    }
                    break block32;
                }
                URL url = c.getProtectionDomain().getCodeSource().getLocation();
                if (url.getPath().endsWith(".jar")) {
                    try {
                        JarFile jarFile = new JarFile(url.getFile());
                        Enumeration<JarEntry> entrys = jarFile.entries();
                        while (entrys.hasMoreElements()) {
                            JarEntry jar = entrys.nextElement();
                            if (jar.getName().indexOf(folder + "/") != 0 || jar.getName().length() <= (folder + "/").length()) continue;
                            Log.info(jar.getName());
                            in = I18nUtils.class.getClassLoader().getResourceAsStream(jar.getName());
                            Properties prop = new Properties();
                            prop.load(in);
                            String key = jar.getName().replace(".properties", "");
                            key = key.replace(folder + "/", "");
                            Log.info("key[1]={}", key);
                            if (ALL_MAPPING.containsKey(key)) {
                                ALL_MAPPING.get(key).putAll((Map<?, ?>)prop);
                                continue;
                            }
                            ALL_MAPPING.put(key, prop);
                        }
                        break block32;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break block32;
                    }
                }
                boolean isSuccess = false;
                String jarPath = url.getPath();
                if (jarPath.indexOf("!") > 0) {
                    try {
                        String filePath = folder + File.separator + defaultLanguage + ".properties";
                        Log.info("filePath[2]={}", filePath);
                        in = I18nUtils.class.getClassLoader().getResourceAsStream(filePath);
                        Properties prop = new Properties();
                        prop.load(in);
                        String key = defaultLanguage;
                        Log.info("key[2]={}, load properties size={}", key, prop.size());
                        if (ALL_MAPPING.containsKey(key)) {
                            ALL_MAPPING.get(key).putAll((Map<?, ?>)prop);
                        } else {
                            ALL_MAPPING.put(key, prop);
                        }
                        isSuccess = true;
                    }
                    catch (Exception e) {
                        Log.error(e.getMessage());
                    }
                }
                if (!isSuccess) {
                    Log.error("unSupport loadLanguage!");
                }
            }
            catch (IOException e) {
                Log.error(e.getMessage());
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static void setLanguage(String lang) throws NulsException {
        if (StringUtils.isBlank(lang)) {
            throw new NulsException(new Error());
        }
        key = lang;
        nowMapping = ALL_MAPPING.get(lang);
        if (nowMapping == null) {
            throw new IllegalArgumentException("config error, can't found language package : " + lang);
        }
    }

    public static String get(String id) {
        if (nowMapping == null) {
            nowMapping = ALL_MAPPING.get(key);
            return id;
        }
        return nowMapping.getProperty(id + "");
    }

    public static boolean hasLanguage(String lang) {
        Objects.requireNonNull(lang, "must be enter language");
        return ALL_MAPPING.containsKey(lang);
    }

    public static String getLanguage() {
        return key;
    }

    public static Map<String, Properties> getAll() {
        return ALL_MAPPING;
    }
}

