/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.core.rpc.modulebootstrap;

import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import network.nerve.core.basic.InitializingBean;
import network.nerve.core.core.annotation.Component;
import network.nerve.core.exception.NulsException;
import network.nerve.core.log.Log;
import network.nerve.core.thread.ThreadUtils;
import network.nerve.core.thread.commom.NulsThreadFactory;

@Component
public class NotifySender
implements Runnable,
InitializingBean {
    ScheduledThreadPoolExecutor executor = ThreadUtils.createScheduledThreadPool(1, new NulsThreadFactory("notify-sender"));
    Queue<Sender> notifyQueue = new ConcurrentLinkedQueue<Sender>();

    @Override
    public void run() {
        while (true) {
            ConcurrentLinkedQueue<Sender> temp = new ConcurrentLinkedQueue<Sender>();
            while (!this.notifyQueue.isEmpty()) {
                Sender sender = this.notifyQueue.poll();
                Callable<Boolean> caller = sender.caller;
                try {
                    Boolean success = caller.call();
                    if (success.booleanValue()) continue;
                    this.retry(temp, sender);
                }
                catch (Exception e) {
                    this.retry(temp, sender);
                }
            }
            while (!temp.isEmpty()) {
                this.notifyQueue.offer((Sender)temp.poll());
            }
            try {
                TimeUnit.SECONDS.sleep(1L);
                continue;
            }
            catch (InterruptedException e) {
                Log.error("notify sender thread error", e);
                continue;
            }
            break;
        }
    }

    private void retry(Queue<Sender> temp, Sender sender) {
        if (sender.canRetry()) {
            Log.warn("notify {} fail, retry {}", sender.key, sender.retry);
            sender.retry();
            temp.offer(sender);
        } else {
            Log.error("rpc module notify fail \uff1a{}", sender.key);
        }
    }

    public void send(String key, int retryTotal, Callable<Boolean> caller) {
        this.notifyQueue.offer(new Sender(key, retryTotal, caller));
    }

    @Override
    public void afterPropertiesSet() throws NulsException {
        this.executor.execute(this);
    }

    private class Sender {
        String key;
        int retry = 0;
        int retryTotal;
        Callable<Boolean> caller;

        void retry() {
            ++this.retry;
        }

        boolean canRetry() {
            return this.retry < this.retryTotal;
        }

        public Sender(String key, int retryTotal, Callable<Boolean> caller) {
            this.retryTotal = retryTotal;
            this.key = key;
            this.caller = caller;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Sender)) {
                return false;
            }
            Sender sender = (Sender)o;
            return this.key != null ? this.key.equals(sender.key) : sender.key == null;
        }

        public int hashCode() {
            return this.key != null ? this.key.hashCode() : 0;
        }
    }
}

