/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.kit.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import network.nerve.SDKContext;
import network.nerve.base.basic.AddressTool;
import network.nerve.base.basic.NulsByteBuffer;
import network.nerve.base.data.MultiSigAccount;
import network.nerve.base.data.Transaction;
import network.nerve.base.signture.MultiSignTxSignature;
import network.nerve.base.signture.P2PHKSignature;
import network.nerve.base.signture.SignatureUtil;
import network.nerve.core.basic.Result;
import network.nerve.core.constant.ErrorCode;
import network.nerve.core.crypto.AESEncrypt;
import network.nerve.core.crypto.Base58;
import network.nerve.core.crypto.ECKey;
import network.nerve.core.crypto.HexUtil;
import network.nerve.core.exception.CryptoException;
import network.nerve.core.exception.NulsException;
import network.nerve.core.exception.NulsRuntimeException;
import network.nerve.core.model.FormatValidUtils;
import network.nerve.core.model.StringUtils;
import network.nerve.kit.error.AccountErrorCode;
import network.nerve.kit.model.Account;
import network.nerve.kit.model.dto.AccountDto;
import network.nerve.kit.model.dto.AccountKeyStoreDto;
import network.nerve.kit.model.dto.RestFulResult;
import network.nerve.kit.model.dto.SignDto;
import network.nerve.kit.util.AccountTool;
import network.nerve.kit.util.CommonValidator;
import network.nerve.kit.util.RestFulUtil;
import network.nerve.kit.util.ValidateUtil;

public class AccountService {
    private static AccountService instance = new AccountService();

    private AccountService() {
    }

    public static AccountService getInstance() {
        return instance;
    }

    public Result<List<String>> createAccount(int count, String password) {
        ValidateUtil.validateChainId();
        try {
            Result result;
            if (!FormatValidUtils.validPassword(password)) {
                throw new NulsException(AccountErrorCode.PASSWORD_FORMAT_WRONG);
            }
            if (count < 1) {
                count = 1;
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("count", count);
            params.put("password", password);
            RestFulResult<Map<String, Object>> restFulResult = RestFulUtil.post("api/account", params);
            if (restFulResult.isSuccess()) {
                Map<String, Object> dataMap = restFulResult.getData();
                result = Result.getSuccess(dataMap.get("list"));
            } else {
                ErrorCode errorCode = ErrorCode.init(restFulResult.getError().getCode());
                result = Result.getFailed(errorCode).setMsg(restFulResult.getError().getMessage());
            }
            return result;
        }
        catch (NulsException e) {
            return Result.getFailed(e.getErrorCode()).setMsg(e.format());
        }
    }

    public Result<List<AccountDto>> createOffLineAccount(int count, String password) {
        ValidateUtil.validateChainId();
        ArrayList<AccountDto> list = new ArrayList<AccountDto>();
        try {
            if (!FormatValidUtils.validPassword(password)) {
                throw new NulsException(AccountErrorCode.PASSWORD_FORMAT_WRONG);
            }
            if (count < 1) {
                count = 1;
            }
            for (int i = 0; i < count; ++i) {
                Account account = StringUtils.isBlank(SDKContext.addressPrefix) ? AccountTool.createAccount(SDKContext.main_chain_id) : AccountTool.createAccount(SDKContext.main_chain_id, null, SDKContext.addressPrefix);
                if (StringUtils.isNotBlank(password)) {
                    account.encrypt(password);
                }
                AccountDto accountDto = new AccountDto();
                accountDto.setAddress(account.getAddress().toString());
                accountDto.setPubKey(HexUtil.encode(account.getPubKey()));
                if (account.isEncrypted()) {
                    accountDto.setPrikey("");
                    accountDto.setEncryptedPrivateKey(HexUtil.encode(account.getEncryptedPriKey()));
                } else {
                    accountDto.setPrikey(HexUtil.encode(account.getPriKey()));
                    accountDto.setEncryptedPrivateKey("");
                }
                list.add(accountDto);
            }
        }
        catch (NulsException e) {
            return Result.getFailed(e.getErrorCode()).setMsg(e.format());
        }
        return Result.getSuccess(list);
    }

    public Result<List<AccountDto>> createOffLineAccount(int chainId, int count, String prefix, String password) {
        ArrayList<AccountDto> list = new ArrayList<AccountDto>();
        try {
            if (!FormatValidUtils.validPassword(password)) {
                throw new NulsException(AccountErrorCode.PASSWORD_FORMAT_WRONG);
            }
            if (count < 1) {
                count = 1;
            }
            for (int i = 0; i < count; ++i) {
                Account account = StringUtils.isBlank(prefix) ? AccountTool.createAccount(chainId) : AccountTool.createAccount(chainId, null, prefix);
                if (StringUtils.isNotBlank(password)) {
                    account.encrypt(password);
                }
                AccountDto accountDto = new AccountDto();
                accountDto.setAddress(account.getAddress().toString());
                accountDto.setPubKey(HexUtil.encode(account.getPubKey()));
                if (account.isEncrypted()) {
                    accountDto.setPrikey("");
                    accountDto.setEncryptedPrivateKey(HexUtil.encode(account.getEncryptedPriKey()));
                } else {
                    accountDto.setPrikey(HexUtil.encode(account.getPriKey()));
                    accountDto.setEncryptedPrivateKey("");
                }
                list.add(accountDto);
            }
        }
        catch (NulsException var8) {
            return Result.getFailed(var8.getErrorCode()).setMsg(var8.format());
        }
        return Result.getSuccess(list);
    }

    public Result getPriKey(String address, String password) {
        ValidateUtil.validateChainId();
        try {
            Result result;
            if (!AddressTool.validAddress(SDKContext.main_chain_id, address)) {
                throw new NulsException(AccountErrorCode.ADDRESS_ERROR);
            }
            if (!FormatValidUtils.validPassword(password)) {
                throw new NulsException(AccountErrorCode.PASSWORD_FORMAT_WRONG);
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("password", password);
            RestFulResult<Map<String, Object>> restFulResult = RestFulUtil.post("api/account/prikey/" + address, params);
            if (restFulResult.isSuccess()) {
                result = Result.getSuccess(restFulResult.getData());
            } else {
                ErrorCode errorCode = ErrorCode.init(restFulResult.getError().getCode());
                result = Result.getFailed(errorCode).setMsg(restFulResult.getError().getMessage());
            }
            return result;
        }
        catch (NulsException e) {
            return Result.getFailed(e.getErrorCode()).setMsg(e.format());
        }
    }

    public Result getPriKeyOffline(String address, String encryptedPriKey, String password) {
        ValidateUtil.validateChainId();
        try {
            if (!AddressTool.validAddress(SDKContext.main_chain_id, address)) {
                throw new NulsException(AccountErrorCode.ADDRESS_ERROR);
            }
            if (StringUtils.isBlank(encryptedPriKey)) {
                throw new NulsException(AccountErrorCode.PARAMETER_ERROR, "encryptedPriKey is invalid");
            }
            if (!FormatValidUtils.validPassword(password)) {
                throw new NulsException(AccountErrorCode.PASSWORD_FORMAT_WRONG);
            }
            byte[] priKeyBytes = AESEncrypt.decrypt(HexUtil.decode(encryptedPriKey), password);
            if (!ECKey.isValidPrivteHex(HexUtil.encode(priKeyBytes))) {
                throw new NulsException(AccountErrorCode.PRIVATE_KEY_WRONG);
            }
            Account account = StringUtils.isBlank(SDKContext.addressPrefix) ? AccountTool.createAccount(SDKContext.main_chain_id, HexUtil.encode(priKeyBytes)) : AccountTool.createAccount(SDKContext.main_chain_id, HexUtil.encode(priKeyBytes), SDKContext.addressPrefix);
            if (!address.equals(account.getAddress().getBase58())) {
                throw new NulsException(AccountErrorCode.ADDRESS_ERROR);
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("priKey", HexUtil.encode(account.getPriKey()));
            return Result.getSuccess(map);
        }
        catch (NulsException e) {
            return Result.getFailed(e.getErrorCode()).setMsg(e.format());
        }
        catch (CryptoException e) {
            return Result.getFailed(AccountErrorCode.PASSWORD_IS_WRONG).setMsg(AccountErrorCode.PASSWORD_IS_WRONG.getMsg());
        }
    }

    public Result importKeystore(AccountKeyStoreDto keyStore, String password) {
        ValidateUtil.validateChainId();
        try {
            Result result;
            if (keyStore == null) {
                throw new NulsException(AccountErrorCode.PARAMETER_ERROR, "[keyStore] is invalid");
            }
            if (!FormatValidUtils.validPassword(password)) {
                throw new NulsException(AccountErrorCode.PASSWORD_FORMAT_WRONG);
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("keystoreString", keyStore);
            params.put("password", password);
            params.put("overwrite", true);
            RestFulResult<Map<String, Object>> restFulResult = RestFulUtil.post("api/account/import/keystore/string", params);
            if (restFulResult.isSuccess()) {
                result = Result.getSuccess(restFulResult.getData());
            } else {
                ErrorCode errorCode = ErrorCode.init(restFulResult.getError().getCode());
                result = Result.getFailed(errorCode).setMsg(restFulResult.getError().getMessage());
            }
            return result;
        }
        catch (NulsException e) {
            return Result.getFailed(e.getErrorCode()).setMsg(e.format());
        }
    }

    public Result exportKeyStore(String address, String password, String filePath) {
        ValidateUtil.validateChainId();
        try {
            Result result;
            if (!AddressTool.validAddress(SDKContext.main_chain_id, address)) {
                throw new NulsException(AccountErrorCode.ADDRESS_ERROR);
            }
            if (StringUtils.isBlank(filePath)) {
                throw new NulsException(AccountErrorCode.PARAMETER_ERROR, "filePath is invalid");
            }
            if (!FormatValidUtils.validPassword(password)) {
                throw new NulsException(AccountErrorCode.PASSWORD_FORMAT_WRONG);
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("password", password);
            params.put("path", filePath);
            RestFulResult<Map<String, Object>> restFulResult = RestFulUtil.post("api/account/export/" + address, params);
            if (restFulResult.isSuccess()) {
                result = Result.getSuccess(restFulResult.getData());
            } else {
                ErrorCode errorCode = ErrorCode.init(restFulResult.getError().getCode());
                result = Result.getFailed(errorCode).setMsg(restFulResult.getError().getMessage());
            }
            return result;
        }
        catch (NulsException e) {
            return Result.getFailed(e.getErrorCode()).setMsg(e.format());
        }
    }

    public Result resetPassword(String address, String oldPassword, String newPassword) {
        ValidateUtil.validateChainId();
        try {
            Result result;
            if (!AddressTool.validAddress(SDKContext.main_chain_id, address)) {
                throw new NulsException(AccountErrorCode.ADDRESS_ERROR);
            }
            if (!FormatValidUtils.validPassword(oldPassword) || !FormatValidUtils.validPassword(newPassword)) {
                throw new NulsException(AccountErrorCode.PASSWORD_FORMAT_WRONG);
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("password", oldPassword);
            params.put("newPassword", newPassword);
            RestFulResult<Map<String, Object>> restFulResult = RestFulUtil.put("api/account/password/" + address, params);
            if (restFulResult.isSuccess()) {
                result = Result.getSuccess(restFulResult.getData());
            } else {
                ErrorCode errorCode = ErrorCode.init(restFulResult.getError().getCode());
                result = Result.getFailed(errorCode).setMsg(restFulResult.getError().getMessage());
            }
            return result;
        }
        catch (NulsException e) {
            return Result.getFailed(e.getErrorCode()).setMsg(e.format());
        }
    }

    public Result setAlias(String address, String alias, String password) {
        Result result;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("password", password);
        params.put("address", address);
        params.put("alias", alias);
        RestFulResult<Map<String, Object>> restFulResult = RestFulUtil.post("api/account/alias/", params);
        if (restFulResult.isSuccess()) {
            result = Result.getSuccess(restFulResult.getData());
        } else {
            ErrorCode errorCode = ErrorCode.init(restFulResult.getError().getCode());
            result = Result.getFailed(errorCode).setMsg(restFulResult.getError().getMessage());
        }
        return result;
    }

    public Result validateAddress(int chainId, String address) {
        boolean b = AddressTool.validAddress(chainId, address);
        if (!b) {
            return Result.getFailed(AccountErrorCode.ADDRESS_ERROR);
        }
        return Result.getSuccess(null);
    }

    public Result resetPasswordOffline(String address, String encryptedPriKey, String oldPassword, String newPassword) {
        ValidateUtil.validateChainId();
        try {
            if (!AddressTool.validAddress(SDKContext.main_chain_id, address)) {
                throw new NulsException(AccountErrorCode.ADDRESS_ERROR);
            }
            if (StringUtils.isBlank(encryptedPriKey)) {
                throw new NulsException(AccountErrorCode.PARAMETER_ERROR, "encryptedPriKey is invalid");
            }
            if (!FormatValidUtils.validPassword(oldPassword) || !FormatValidUtils.validPassword(newPassword)) {
                throw new NulsException(AccountErrorCode.PASSWORD_FORMAT_WRONG);
            }
            byte[] priKeyBytes = AESEncrypt.decrypt(HexUtil.decode(encryptedPriKey), oldPassword);
            if (!ECKey.isValidPrivteHex(HexUtil.encode(priKeyBytes))) {
                throw new NulsException(AccountErrorCode.PRIVATE_KEY_WRONG);
            }
            Account account = StringUtils.isBlank(SDKContext.addressPrefix) ? AccountTool.createAccount(SDKContext.main_chain_id, HexUtil.encode(priKeyBytes)) : AccountTool.createAccount(SDKContext.main_chain_id, HexUtil.encode(priKeyBytes), SDKContext.addressPrefix);
            if (!address.equals(account.getAddress().getBase58())) {
                throw new NulsException(AccountErrorCode.ADDRESS_ERROR);
            }
            account.encrypt(newPassword);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("newEncryptedPriKey", HexUtil.encode(account.getEncryptedPriKey()));
            return Result.getSuccess(map);
        }
        catch (NulsException e) {
            return Result.getFailed(e.getErrorCode()).setMsg(e.format());
        }
        catch (CryptoException e) {
            return Result.getFailed(AccountErrorCode.PASSWORD_IS_WRONG).setMsg(AccountErrorCode.PASSWORD_IS_WRONG.getMsg());
        }
    }

    public Result sign(List<SignDto> signDtoList, String txHex) {
        ValidateUtil.validateChainId();
        try {
            CommonValidator.validateSignDto(signDtoList);
            if (StringUtils.isBlank(txHex)) {
                throw new NulsRuntimeException(AccountErrorCode.PARAMETER_ERROR, "txHex is invalid");
            }
            ArrayList<ECKey> signEcKeys = new ArrayList<ECKey>();
            for (SignDto signDto : signDtoList) {
                byte[] priKeyBytes;
                if (StringUtils.isNotBlank(signDto.getPriKey())) {
                    if (!ECKey.isValidPrivteHex(signDto.getPriKey())) {
                        throw new NulsRuntimeException(AccountErrorCode.PRIVATE_KEY_WRONG, signDto.getPriKey() + " is invalid");
                    }
                    priKeyBytes = HexUtil.decode(signDto.getPriKey());
                } else {
                    try {
                        priKeyBytes = AESEncrypt.decrypt(HexUtil.decode(signDto.getEncryptedPrivateKey()), signDto.getPassword());
                        if (!ECKey.isValidPrivteHex(HexUtil.encode(priKeyBytes))) {
                            throw new NulsRuntimeException(AccountErrorCode.PRIVATE_KEY_WRONG, signDto.getEncryptedPrivateKey() + " is invalid");
                        }
                    }
                    catch (CryptoException e) {
                        throw new NulsException(AccountErrorCode.PARAMETER_ERROR, "encryptedPrivateKey[" + signDto.getEncryptedPrivateKey() + "] password error");
                    }
                }
                Account account = StringUtils.isBlank(SDKContext.addressPrefix) ? AccountTool.createAccount(SDKContext.main_chain_id, HexUtil.encode(priKeyBytes)) : AccountTool.createAccount(SDKContext.main_chain_id, HexUtil.encode(priKeyBytes), SDKContext.addressPrefix);
                if (!signDto.getAddress().equals(account.getAddress().getBase58())) {
                    throw new NulsRuntimeException(AccountErrorCode.ADDRESS_ERROR, account.getAddress() + " and private key do not match");
                }
                ECKey ecKey = account.getEcKey(signDto.getPassword());
                signEcKeys.add(ecKey);
            }
            Transaction tx = new Transaction();
            tx.parse(new NulsByteBuffer(HexUtil.decode(txHex)));
            SignatureUtil.createOrAddTransactionSignture(tx, signEcKeys);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("hash", tx.getHash().toHex());
            map.put("txHex", HexUtil.encode(tx.serialize()));
            return Result.getSuccess(map);
        }
        catch (NulsException e) {
            return Result.getFailed(e.getErrorCode()).setMsg(e.format());
        }
        catch (Exception e) {
            return Result.getFailed(AccountErrorCode.SERIALIZE_ERROR).setMsg(AccountErrorCode.SERIALIZE_ERROR.getMsg());
        }
    }

    public Result sign(int chainId, String prefix, List<SignDto> signDtoList, String txHex) {
        try {
            if (StringUtils.isBlank(txHex)) {
                throw new NulsRuntimeException(AccountErrorCode.PARAMETER_ERROR, "txHex is invalid");
            }
            ArrayList<ECKey> signEcKeys = new ArrayList<ECKey>();
            for (SignDto signDto : signDtoList) {
                byte[] priKeyBytes;
                if (StringUtils.isNotBlank(signDto.getPriKey())) {
                    if (!ECKey.isValidPrivteHex(signDto.getPriKey())) {
                        throw new NulsRuntimeException(AccountErrorCode.PRIVATE_KEY_WRONG, signDto.getPriKey() + " is invalid");
                    }
                    priKeyBytes = HexUtil.decode(signDto.getPriKey());
                } else {
                    try {
                        priKeyBytes = AESEncrypt.decrypt(HexUtil.decode(signDto.getEncryptedPrivateKey()), signDto.getPassword());
                        if (!ECKey.isValidPrivteHex(HexUtil.encode(priKeyBytes))) {
                            throw new NulsRuntimeException(AccountErrorCode.PRIVATE_KEY_WRONG, signDto.getEncryptedPrivateKey() + " is invalid");
                        }
                    }
                    catch (CryptoException e) {
                        throw new NulsException(AccountErrorCode.PARAMETER_ERROR, "encryptedPrivateKey[" + signDto.getEncryptedPrivateKey() + "] password error");
                    }
                }
                Account account = StringUtils.isBlank(prefix) ? AccountTool.createAccount(chainId, HexUtil.encode(priKeyBytes)) : AccountTool.createAccount(chainId, HexUtil.encode(priKeyBytes), prefix);
                if (!signDto.getAddress().equals(account.getAddress().getBase58())) {
                    throw new NulsRuntimeException(AccountErrorCode.ADDRESS_ERROR, account.getAddress() + " and private key do not match");
                }
                ECKey ecKey = account.getEcKey(signDto.getPassword());
                signEcKeys.add(ecKey);
            }
            Transaction tx = new Transaction();
            tx.parse(new NulsByteBuffer(HexUtil.decode(txHex)));
            SignatureUtil.createTransactionSignture(tx, signEcKeys);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("hash", tx.getHash().toHex());
            map.put("txHex", HexUtil.encode(tx.serialize()));
            return Result.getSuccess(map);
        }
        catch (NulsException e) {
            return Result.getFailed(e.getErrorCode()).setMsg(e.format());
        }
        catch (IOException e) {
            return Result.getFailed(AccountErrorCode.SERIALIZE_ERROR).setMsg(AccountErrorCode.SERIALIZE_ERROR.getMsg());
        }
    }

    public Result sign(String txHex, int chainId, String prefix, String address, String encryptedPrivateKey, String password) {
        if (StringUtils.isBlank(txHex)) {
            throw new NulsRuntimeException(AccountErrorCode.PARAMETER_ERROR, "txHex is invalid");
        }
        try {
            byte[] priKeyBytes;
            ArrayList<ECKey> signEcKeys = new ArrayList<ECKey>();
            try {
                priKeyBytes = AESEncrypt.decrypt(HexUtil.decode(encryptedPrivateKey), password);
                if (!ECKey.isValidPrivteHex(HexUtil.encode(priKeyBytes))) {
                    throw new NulsRuntimeException(AccountErrorCode.PRIVATE_KEY_WRONG, encryptedPrivateKey + " is invalid");
                }
            }
            catch (CryptoException e) {
                throw new NulsException(AccountErrorCode.PARAMETER_ERROR, "encryptedPrivateKey[" + encryptedPrivateKey + "] password error");
            }
            Account account = StringUtils.isBlank(prefix) ? AccountTool.createAccount(chainId, HexUtil.encode(priKeyBytes)) : AccountTool.createAccount(chainId, HexUtil.encode(priKeyBytes), prefix);
            if (!address.equals(account.getAddress().getBase58())) {
                throw new NulsRuntimeException(AccountErrorCode.ADDRESS_ERROR, account.getAddress() + " and private key do not match");
            }
            ECKey ecKey = account.getEcKey(password);
            signEcKeys.add(ecKey);
            Transaction tx = new Transaction();
            tx.parse(new NulsByteBuffer(HexUtil.decode(txHex)));
            SignatureUtil.createTransactionSignture(tx, signEcKeys);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("hash", tx.getHash().toHex());
            map.put("txHex", HexUtil.encode(tx.serialize()));
            return Result.getSuccess(map);
        }
        catch (NulsException e) {
            return Result.getFailed(e.getErrorCode()).setMsg(e.format());
        }
        catch (IOException e) {
            return Result.getFailed(AccountErrorCode.SERIALIZE_ERROR).setMsg(AccountErrorCode.SERIALIZE_ERROR.getMsg());
        }
    }

    public Result multiSign(SignDto signDto, String txHex) {
        ValidateUtil.validateChainId();
        try {
            P2PHKSignature p2PHKSignature;
            Object bytes2;
            byte[] priKeyBytes;
            CommonValidator.validateSignDto(signDto);
            if (StringUtils.isBlank(txHex)) {
                throw new NulsRuntimeException(AccountErrorCode.PARAMETER_ERROR, "txHex is invalid");
            }
            Transaction tx = new Transaction();
            tx.parse(new NulsByteBuffer(HexUtil.decode(txHex)));
            if (tx.getTransactionSignature() == null) {
                throw new NulsRuntimeException(AccountErrorCode.PARAMETER_ERROR, "is not multiSign TransferTx");
            }
            if (StringUtils.isNotBlank(signDto.getPriKey())) {
                if (!ECKey.isValidPrivteHex(signDto.getPriKey())) {
                    throw new NulsRuntimeException(AccountErrorCode.PRIVATE_KEY_WRONG, signDto.getPriKey() + " is invalid");
                }
                priKeyBytes = HexUtil.decode(signDto.getPriKey());
            } else {
                try {
                    priKeyBytes = AESEncrypt.decrypt(HexUtil.decode(signDto.getEncryptedPrivateKey()), signDto.getPassword());
                    if (!ECKey.isValidPrivteHex(HexUtil.encode(priKeyBytes))) {
                        throw new NulsRuntimeException(AccountErrorCode.PRIVATE_KEY_WRONG, signDto.getEncryptedPrivateKey() + " is invalid");
                    }
                }
                catch (CryptoException e) {
                    throw new NulsException(AccountErrorCode.PARAMETER_ERROR, "encryptedPrivateKey[" + signDto.getEncryptedPrivateKey() + "] password error");
                }
            }
            Account account = StringUtils.isBlank(SDKContext.addressPrefix) ? AccountTool.createAccount(SDKContext.main_chain_id, HexUtil.encode(priKeyBytes)) : AccountTool.createAccount(SDKContext.main_chain_id, HexUtil.encode(priKeyBytes), SDKContext.addressPrefix);
            if (!signDto.getAddress().equals(account.getAddress().getBase58())) {
                throw new NulsRuntimeException(AccountErrorCode.ADDRESS_ERROR, account.getAddress() + " and private key do not match");
            }
            MultiSignTxSignature transactionSignature = new MultiSignTxSignature();
            transactionSignature.parse(new NulsByteBuffer(tx.getTransactionSignature()));
            boolean hasPubKey = false;
            for (Object bytes2 : transactionSignature.getPubKeyList()) {
                if (!Arrays.equals(bytes2, account.getPubKey())) continue;
                hasPubKey = true;
            }
            if (!hasPubKey) {
                throw new NulsRuntimeException(AccountErrorCode.ADDRESS_ERROR, account.getAddress() + " not one of the multiSign address");
            }
            List<P2PHKSignature> p2PHKSignatures = transactionSignature.getP2PHKSignatures();
            if (p2PHKSignatures == null) {
                p2PHKSignatures = new ArrayList<P2PHKSignature>();
            }
            bytes2 = p2PHKSignatures.iterator();
            while (bytes2.hasNext()) {
                p2PHKSignature = (P2PHKSignature)bytes2.next();
                if (!Arrays.equals(p2PHKSignature.getPublicKey(), account.getPubKey())) continue;
                throw new NulsRuntimeException(AccountErrorCode.ADDRESS_ALREADY_SIGNED);
            }
            ECKey ecKey = account.getEcKey(signDto.getPassword());
            p2PHKSignature = SignatureUtil.createSignatureByEckey(tx, ecKey);
            p2PHKSignatures.add(p2PHKSignature);
            transactionSignature.setP2PHKSignatures(p2PHKSignatures);
            tx.setTransactionSignature(transactionSignature.serialize());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("hash", tx.getHash().toHex());
            map.put("txHex", HexUtil.encode(tx.serialize()));
            return Result.getSuccess(map);
        }
        catch (NulsException e) {
            return Result.getFailed(e.getErrorCode()).setMsg(e.format());
        }
        catch (IOException e) {
            return Result.getFailed(AccountErrorCode.SERIALIZE_ERROR).setMsg(AccountErrorCode.SERIALIZE_ERROR.getMsg());
        }
    }

    public Result multiSign(int chainId, String prefix, String address, String encryptedPrivateKey, String password, String txHex) {
        ValidateUtil.validateChainId();
        try {
            P2PHKSignature p2PHKSignature;
            Object bytes2;
            byte[] priKeyBytes;
            if (StringUtils.isBlank(txHex)) {
                throw new NulsRuntimeException(AccountErrorCode.PARAMETER_ERROR, "txHex is invalid");
            }
            Transaction tx = new Transaction();
            tx.parse(new NulsByteBuffer(HexUtil.decode(txHex)));
            if (tx.getTransactionSignature() == null) {
                throw new NulsRuntimeException(AccountErrorCode.PARAMETER_ERROR, "is not multiSign TransferTx");
            }
            try {
                priKeyBytes = AESEncrypt.decrypt(HexUtil.decode(encryptedPrivateKey), password);
                if (!ECKey.isValidPrivteHex(HexUtil.encode(priKeyBytes))) {
                    throw new NulsRuntimeException(AccountErrorCode.PRIVATE_KEY_WRONG, encryptedPrivateKey + " is invalid");
                }
            }
            catch (CryptoException e) {
                throw new NulsException(AccountErrorCode.PARAMETER_ERROR, "encryptedPrivateKey[" + encryptedPrivateKey + "] password error");
            }
            Account account = StringUtils.isBlank(SDKContext.addressPrefix) ? AccountTool.createAccount(SDKContext.main_chain_id, HexUtil.encode(priKeyBytes)) : AccountTool.createAccount(SDKContext.main_chain_id, HexUtil.encode(priKeyBytes), SDKContext.addressPrefix);
            if (!address.equals(account.getAddress().getBase58())) {
                throw new NulsRuntimeException(AccountErrorCode.ADDRESS_ERROR, account.getAddress() + " and private key do not match");
            }
            MultiSignTxSignature transactionSignature = new MultiSignTxSignature();
            transactionSignature.parse(new NulsByteBuffer(tx.getTransactionSignature()));
            boolean hasPubKey = false;
            for (Object bytes2 : transactionSignature.getPubKeyList()) {
                if (!Arrays.equals(bytes2, account.getPubKey())) continue;
                hasPubKey = true;
            }
            if (!hasPubKey) {
                throw new NulsRuntimeException(AccountErrorCode.ADDRESS_ERROR, account.getAddress() + " not one of the multiSign address");
            }
            List<P2PHKSignature> p2PHKSignatures = transactionSignature.getP2PHKSignatures();
            if (p2PHKSignatures == null) {
                p2PHKSignatures = new ArrayList<P2PHKSignature>();
            }
            bytes2 = p2PHKSignatures.iterator();
            while (bytes2.hasNext()) {
                p2PHKSignature = (P2PHKSignature)bytes2.next();
                if (!Arrays.equals(p2PHKSignature.getPublicKey(), account.getPubKey())) continue;
                throw new NulsRuntimeException(AccountErrorCode.ADDRESS_ALREADY_SIGNED);
            }
            ECKey ecKey = account.getEcKey(password);
            p2PHKSignature = SignatureUtil.createSignatureByEckey(tx, ecKey);
            p2PHKSignatures.add(p2PHKSignature);
            transactionSignature.setP2PHKSignatures(p2PHKSignatures);
            tx.setTransactionSignature(transactionSignature.serialize());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("hash", tx.getHash().toHex());
            map.put("txHex", HexUtil.encode(tx.serialize()));
            return Result.getSuccess(map);
        }
        catch (NulsException e) {
            return Result.getFailed(e.getErrorCode()).setMsg(e.format());
        }
        catch (IOException e) {
            return Result.getFailed(AccountErrorCode.SERIALIZE_ERROR).setMsg(AccountErrorCode.SERIALIZE_ERROR.getMsg());
        }
    }

    public Result getAccountBalance(String address, int chainId, int assetsId) {
        Result result;
        ValidateUtil.validateChainId();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("assetChainId", chainId);
        params.put("assetId", assetsId);
        RestFulResult<Map<String, Object>> restFulResult = RestFulUtil.post("api/accountledger/balance/" + address, params);
        if (restFulResult.isSuccess()) {
            result = Result.getSuccess(restFulResult.getData());
        } else {
            ErrorCode errorCode = ErrorCode.init(restFulResult.getError().getCode());
            result = Result.getFailed(errorCode).setMsg(restFulResult.getError().getMessage());
        }
        return result;
    }

    public Result importPriKey(String priKey, String password) {
        ValidateUtil.validateChainId();
        try {
            Result result;
            if (StringUtils.isBlank(priKey)) {
                throw new NulsException(AccountErrorCode.PARAMETER_ERROR, "priKey[" + priKey + "] is invalid");
            }
            if (!FormatValidUtils.validPassword(password)) {
                throw new NulsException(AccountErrorCode.PARAMETER_ERROR, "password[" + password + "] is invalid");
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("priKey", priKey);
            params.put("password", password);
            params.put("overwrite", true);
            RestFulResult<Map<String, Object>> restFulResult = RestFulUtil.post("api/account/import/pri", params);
            if (restFulResult.isSuccess()) {
                result = Result.getSuccess(restFulResult.getData());
            } else {
                ErrorCode errorCode = ErrorCode.init(restFulResult.getError().getCode());
                result = Result.getFailed(errorCode).setMsg(restFulResult.getError().getMessage());
            }
            return result;
        }
        catch (NulsException e) {
            return Result.getFailed(e.getErrorCode()).setMsg(e.format());
        }
    }

    public Result createMultiSignAccount(List<String> pubKeys, int minSigns) {
        ValidateUtil.validateChainId();
        try {
            if (pubKeys == null || pubKeys.isEmpty()) {
                throw new NulsException(AccountErrorCode.PARAMETER_ERROR, "pubKeys is invalid");
            }
            if (minSigns < 1 || minSigns > pubKeys.size()) {
                throw new NulsException(AccountErrorCode.PARAMETER_ERROR, "minSigns is invalid");
            }
            MultiSigAccount multiSigAccount = AccountTool.createMultiSigAccount(SDKContext.main_chain_id, pubKeys, minSigns);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("value", multiSigAccount.getAddress().getBase58());
            return Result.getSuccess(map);
        }
        catch (NulsException e) {
            return Result.getFailed(e.getErrorCode()).setMsg(e.format());
        }
    }

    public Result getAddressByPriKey(String priKey) {
        Account account;
        ValidateUtil.validateChainId();
        if (!ECKey.isValidPrivteHex(priKey)) {
            throw new NulsRuntimeException(AccountErrorCode.PRIVATE_KEY_WRONG);
        }
        try {
            account = StringUtils.isBlank(SDKContext.addressPrefix) ? AccountTool.createAccount(SDKContext.main_chain_id, priKey) : AccountTool.createAccount(SDKContext.main_chain_id, priKey, SDKContext.addressPrefix);
        }
        catch (NulsException e) {
            throw new NulsRuntimeException(AccountErrorCode.PRIVATE_KEY_WRONG);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("value", account.getAddress().getBase58());
        return Result.getSuccess(map);
    }

    public static byte[] getAddress(String addressString) {
        byte[] bytes;
        try {
            bytes = Base58.decode(addressString);
        }
        catch (Exception var3) {
            return null;
        }
        byte[] result = new byte[23];
        System.arraycopy(bytes, 0, result, 0, 23);
        return result;
    }
}

