/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.kit.txdata;

import java.io.IOException;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;
import network.nerve.base.basic.NulsByteBuffer;
import network.nerve.base.basic.NulsOutputStreamBuffer;
import network.nerve.base.data.BaseNulsData;
import network.nerve.base.data.NulsHash;
import network.nerve.core.exception.NulsException;
import network.nerve.core.parse.SerializeUtils;
import network.nerve.core.rpc.model.ApiModel;
import network.nerve.core.rpc.model.ApiModelProperty;

@ApiModel(name="\u8282\u70b9\u4fe1\u606f")
public class Agent
extends BaseNulsData {
    @ApiModelProperty(description="\u8282\u70b9\u5730\u5740")
    private byte[] agentAddress;
    @ApiModelProperty(description="\u51fa\u5757\u5730\u5740")
    private byte[] packingAddress;
    @ApiModelProperty(description="\u5956\u52b1\u5730\u5740")
    private byte[] rewardAddress;
    @ApiModelProperty(description="\u4fdd\u8bc1\u91d1")
    private BigInteger deposit;
    @ApiModelProperty(description="\u4f63\u91d1\u6bd4\u4f8b")
    private byte commissionRate;
    @ApiModelProperty(description="\u521b\u5efa\u65f6\u95f4")
    private transient long time;
    @ApiModelProperty(description="\u6240\u5728\u533a\u5757\u9ad8\u5ea6")
    private transient long blockHeight = -1L;
    @ApiModelProperty(description="\u8282\u70b9\u6ce8\u9500\u9ad8\u5ea6")
    private transient long delHeight = -1L;
    @ApiModelProperty(description="\u72b6\u6001\uff0c0:\u5f85\u5171\u8bc6 unConsensus, 1:\u5171\u8bc6\u4e2d consensus")
    private transient int status;
    @ApiModelProperty(description="\u4fe1\u8a89\u503c")
    private transient double creditVal;
    @ApiModelProperty(description="\u8282\u70b9\u603b\u59d4\u6258\u91d1\u989d")
    private transient BigInteger totalDeposit = BigInteger.ZERO;
    @ApiModelProperty(description="\u521b\u5efa\u8be5\u8282\u70b9\u7684\u4ea4\u6613HASH")
    private transient NulsHash txHash;
    @ApiModelProperty(description="\u53c2\u4e0e\u5171\u8bc6\u4eba\u6570")
    private transient int memberCount;
    @ApiModelProperty(description="\u8282\u70b9\u522b\u540d")
    private transient String alais;

    @Override
    public int size() {
        int size = 0;
        size += SerializeUtils.sizeOfBigInteger();
        size += this.agentAddress.length;
        size += this.rewardAddress.length;
        size += this.packingAddress.length;
        return ++size;
    }

    @Override
    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeBigInteger(this.deposit);
        stream.write(this.agentAddress);
        stream.write(this.packingAddress);
        stream.write(this.rewardAddress);
        stream.write(this.commissionRate);
    }

    @Override
    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.deposit = byteBuffer.readBigInteger();
        this.agentAddress = byteBuffer.readBytes(23);
        this.packingAddress = byteBuffer.readBytes(23);
        this.rewardAddress = byteBuffer.readBytes(23);
        this.commissionRate = byteBuffer.readByte();
    }

    public byte[] getPackingAddress() {
        return this.packingAddress;
    }

    public void setPackingAddress(byte[] packingAddress) {
        this.packingAddress = packingAddress;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public byte getCommissionRate() {
        return this.commissionRate;
    }

    public void setCommissionRate(byte commissionRate) {
        this.commissionRate = commissionRate;
    }

    public long getBlockHeight() {
        return this.blockHeight;
    }

    public void setBlockHeight(long blockHeight) {
        this.blockHeight = blockHeight;
    }

    public void setCreditVal(double creditVal) {
        this.creditVal = creditVal;
    }

    public double getCreditVal() {
        return this.creditVal < 0.0 ? 0.0 : this.creditVal;
    }

    public double getRealCreditVal() {
        return this.creditVal;
    }

    public void setTxHash(NulsHash txHash) {
        this.txHash = txHash;
    }

    public NulsHash getTxHash() {
        return this.txHash;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public long getDelHeight() {
        return this.delHeight;
    }

    public void setDelHeight(long delHeight) {
        this.delHeight = delHeight;
    }

    public byte[] getAgentAddress() {
        return this.agentAddress;
    }

    public void setAgentAddress(byte[] agentAddress) {
        this.agentAddress = agentAddress;
    }

    public byte[] getRewardAddress() {
        return this.rewardAddress;
    }

    public void setRewardAddress(byte[] rewardAddress) {
        this.rewardAddress = rewardAddress;
    }

    public int getMemberCount() {
        return this.memberCount;
    }

    public void setMemberCount(int memberCount) {
        this.memberCount = memberCount;
    }

    public BigInteger getDeposit() {
        return this.deposit;
    }

    public void setDeposit(BigInteger deposit) {
        this.deposit = deposit;
    }

    public BigInteger getTotalDeposit() {
        return this.totalDeposit;
    }

    public void setTotalDeposit(BigInteger totalDeposit) {
        this.totalDeposit = totalDeposit;
    }

    public Agent clone() throws CloneNotSupportedException {
        return (Agent)super.clone();
    }

    public Set<byte[]> getAddresses() {
        HashSet<byte[]> addressSet = new HashSet<byte[]>();
        addressSet.add(this.agentAddress);
        return addressSet;
    }

    public String getAlais() {
        return this.alais;
    }

    public void setAlais(String alais) {
        this.alais = alais;
    }
}

