/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.base.basic;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import network.nerve.base.data.BaseNulsData;
import network.nerve.core.basic.VarInt;
import network.nerve.core.constant.ToolsConstant;
import network.nerve.core.exception.NulsRuntimeException;
import network.nerve.core.log.Log;
import network.nerve.core.model.ByteUtils;
import network.nerve.core.model.StringUtils;
import network.nerve.core.parse.SerializeUtils;

public class NulsOutputStreamBuffer {
    private final OutputStream out;

    public NulsOutputStreamBuffer(OutputStream out) {
        this.out = out;
    }

    public void writeByte(byte b) throws IOException {
        this.out.write(b);
    }

    public void write(byte[] bytes) throws IOException {
        this.out.write(bytes);
    }

    public void write(int val) throws IOException {
        this.out.write(val);
    }

    public void writeVarInt(int val) throws IOException {
        this.out.write(new VarInt(val).encode());
    }

    public void writeVarInt(long val) throws IOException {
        this.out.write(new VarInt(val).encode());
    }

    public void writeBytesWithLength(byte[] bytes) throws IOException {
        if (null == bytes || bytes.length == 0) {
            this.out.write(new VarInt(0L).encode());
        } else {
            this.out.write(new VarInt(bytes.length).encode());
            this.out.write(bytes);
        }
    }

    public void writeBoolean(boolean val) throws IOException {
        this.out.write(val ? 1 : 0);
    }

    public void writeShort(short val) throws IOException {
        SerializeUtils.int16ToByteStreamLE(val, this.out);
    }

    public void writeUint8(short val) throws IOException {
        SerializeUtils.uint8ToByteStreamLE(val, this.out);
    }

    public void writeUint16(int val) throws IOException {
        SerializeUtils.uint16ToByteStreamLE(val, this.out);
    }

    public void writeUint32(long val) throws IOException {
        SerializeUtils.uint32ToByteStreamLE(val, this.out);
    }

    public void writeUint48(long time) throws IOException {
        this.write(SerializeUtils.uint48ToBytes(time));
    }

    public void writeBigInteger(BigInteger val) throws IOException {
        if (val.compareTo(BigInteger.ZERO) < 0) {
            throw new UnsupportedOperationException();
        }
        this.write(SerializeUtils.bigInteger2Bytes(val));
    }

    public void writeInt64(long val) throws IOException {
        SerializeUtils.int64ToByteStreamLE(val, this.out);
    }

    public void writeDouble(double val) throws IOException {
        this.out.write(ByteUtils.doubleToBytes(val));
    }

    public void writeString(String val) {
        if (StringUtils.isBlank(val)) {
            try {
                this.out.write(new VarInt(0L).encode());
            }
            catch (IOException e) {
                Log.error(e);
                throw new NulsRuntimeException(e);
            }
            return;
        }
        try {
            this.writeBytesWithLength(val.getBytes(ToolsConstant.DEFAULT_ENCODING));
        }
        catch (IOException e) {
            Log.error(e);
            throw new NulsRuntimeException(e);
        }
    }

    public void writeNulsData(BaseNulsData data) throws IOException {
        if (null == data) {
            this.write(ToolsConstant.PLACE_HOLDER);
        } else {
            this.write(data.serialize());
        }
    }
}

