/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.base.data;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import network.nerve.base.basic.NulsByteBuffer;
import network.nerve.base.basic.NulsOutputStreamBuffer;
import network.nerve.base.data.BaseNulsData;
import network.nerve.base.data.BlockHeader;
import network.nerve.base.data.NulsHash;
import network.nerve.base.data.Transaction;
import network.nerve.core.exception.NulsException;
import network.nerve.core.parse.SerializeUtils;

public class SmallBlock
extends BaseNulsData {
    private BlockHeader header;
    private ArrayList<NulsHash> txHashList;
    private List<Transaction> systemTxList = new ArrayList<Transaction>();

    @Override
    public int size() {
        int size = this.header.size();
        size += SerializeUtils.sizeOfVarInt(this.txHashList.size());
        size += this.txHashList.size() * 32;
        size += SerializeUtils.sizeOfVarInt(this.systemTxList.size());
        for (Transaction tx : this.systemTxList) {
            size += SerializeUtils.sizeOfNulsData(tx);
        }
        return size;
    }

    @Override
    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeNulsData(this.header);
        stream.writeVarInt(this.txHashList.size());
        for (NulsHash hash : this.txHashList) {
            stream.write(hash.getBytes());
        }
        stream.writeVarInt(this.systemTxList.size());
        for (Transaction tx : this.systemTxList) {
            stream.writeNulsData(tx);
        }
    }

    @Override
    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.header = byteBuffer.readNulsData(new BlockHeader());
        this.txHashList = new ArrayList();
        long hashListSize = byteBuffer.readVarInt();
        int i = 0;
        while ((long)i < hashListSize) {
            this.txHashList.add(byteBuffer.readHash());
            ++i;
        }
        this.systemTxList = new ArrayList<Transaction>();
        long subTxListSize = byteBuffer.readVarInt();
        int i2 = 0;
        while ((long)i2 < subTxListSize) {
            Transaction tx = byteBuffer.readTransaction();
            tx.setBlockHeight(this.header.getHeight());
            this.systemTxList.add(tx);
            ++i2;
        }
    }

    public BlockHeader getHeader() {
        return this.header;
    }

    public void setHeader(BlockHeader header) {
        this.header = header;
    }

    public ArrayList<NulsHash> getTxHashList() {
        return this.txHashList;
    }

    public void setTxHashList(ArrayList<NulsHash> txHashList) {
        this.txHashList = txHashList;
    }

    public List<Transaction> getSystemTxList() {
        return this.systemTxList;
    }

    public void addSystemTx(Transaction tx) {
        this.systemTxList.add(tx);
    }
}

