/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.base.data;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import network.nerve.base.basic.NulsByteBuffer;
import network.nerve.base.basic.NulsOutputStreamBuffer;
import network.nerve.base.data.BaseNulsData;
import network.nerve.core.exception.NulsException;
import network.nerve.core.parse.SerializeUtils;

public class YellowPunishData
extends BaseNulsData {
    private List<byte[]> addressList = new ArrayList<byte[]>();

    public List<byte[]> getAddressList() {
        return this.addressList;
    }

    public void setAddressList(List<byte[]> addressList) {
        this.addressList = addressList;
    }

    public Set<byte[]> getAddresses() {
        return new HashSet<byte[]>(this.addressList);
    }

    @Override
    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeVarInt(this.addressList.size());
        for (byte[] address : this.addressList) {
            stream.write(address);
        }
    }

    @Override
    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        int count = (int)byteBuffer.readVarInt();
        this.addressList.clear();
        for (int i = 0; i < count; ++i) {
            this.addressList.add(byteBuffer.readBytes(23));
        }
    }

    @Override
    public int size() {
        int size = SerializeUtils.sizeOfVarInt(this.addressList.size());
        for (byte[] address : this.addressList) {
            size += 23;
        }
        return size;
    }
}

