/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.core.core.inteceptor.base;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.sf.cglib.proxy.MethodProxy;
import network.nerve.core.core.inteceptor.base.BeanMethodInterceptor;
import network.nerve.core.core.inteceptor.base.BeanMethodInterceptorChain;
import network.nerve.core.core.inteceptor.base.MultipleBeanMethodInterceptorChain;

public class BeanMethodInterceptorManager {
    private static final Map<Class, BeanMethodInterceptorChain> INTERCEPTOR_MAP = new HashMap<Class, BeanMethodInterceptorChain>();

    public static void addBeanMethodInterceptor(Class annotationType, BeanMethodInterceptor interceptor) {
        BeanMethodInterceptorChain interceptorChain = INTERCEPTOR_MAP.get(annotationType);
        if (null == interceptorChain) {
            interceptorChain = new BeanMethodInterceptorChain();
            INTERCEPTOR_MAP.put(annotationType, interceptorChain);
        }
        interceptorChain.add(interceptor);
    }

    public static Object doInterceptor(Annotation[] annotations, Object object, Method method, Object[] params, MethodProxy methodProxy) throws Throwable {
        ArrayList<Annotation> annotationList = new ArrayList<Annotation>();
        ArrayList<BeanMethodInterceptorChain> chainList = new ArrayList<BeanMethodInterceptorChain>();
        for (Annotation ann : annotations) {
            BeanMethodInterceptorChain chain = INTERCEPTOR_MAP.get(ann.annotationType());
            if (null == chain) continue;
            chainList.add(chain);
            annotationList.add(ann);
        }
        if (annotationList.isEmpty()) {
            return methodProxy.invokeSuper(object, params);
        }
        MultipleBeanMethodInterceptorChain chain = new MultipleBeanMethodInterceptorChain(annotationList, chainList);
        return chain.startInterceptor(null, object, method, params, methodProxy);
    }
}

