/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.kit.txdata;

import java.io.IOException;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;
import network.nerve.base.basic.NulsByteBuffer;
import network.nerve.base.basic.NulsOutputStreamBuffer;
import network.nerve.base.data.BaseNulsData;
import network.nerve.base.data.NulsHash;
import network.nerve.core.exception.NulsException;
import network.nerve.core.parse.SerializeUtils;
import network.nerve.core.rpc.model.ApiModel;
import network.nerve.core.rpc.model.ApiModelProperty;

@ApiModel(name="\u8282\u70b9\u4fe1\u606f")
public class Agent
extends BaseNulsData {
    @ApiModelProperty(description="\u8282\u70b9\u5730\u5740")
    private byte[] agentAddress;
    @ApiModelProperty(description="\u51fa\u5757\u5730\u5740")
    private byte[] packingAddress;
    @ApiModelProperty(description="\u5956\u52b1\u5730\u5740")
    private byte[] rewardAddress;
    @ApiModelProperty(description="\u4fdd\u8bc1\u91d1")
    private BigInteger deposit;
    @ApiModelProperty(description="\u521b\u5efa\u65f6\u95f4")
    private transient long time;
    @ApiModelProperty(description="\u6240\u5728\u533a\u5757\u9ad8\u5ea6")
    private transient long blockHeight = -1L;
    @ApiModelProperty(description="\u8282\u70b9\u6ce8\u9500\u9ad8\u5ea6")
    private transient long delHeight = -1L;
    @ApiModelProperty(description="\u72b6\u6001\uff0c0:\u5f85\u5171\u8bc6 unConsensus, 1:\u5171\u8bc6\u4e2d consensus")
    private transient int status;
    @ApiModelProperty(description="\u4fe1\u8a89\u503c")
    private transient double creditVal;
    @ApiModelProperty(description="\u521b\u5efa\u8be5\u8282\u70b9\u7684\u4ea4\u6613HASH")
    private transient NulsHash txHash;
    @ApiModelProperty(description="\u8282\u70b9\u522b\u540d")
    private transient String alias;
    @ApiModelProperty(description="\u8282\u70b9\u522b\u540d")
    private transient byte[] pubKey;
    private transient String packingAddressStr;

    @Override
    public int size() {
        int size = 0;
        size += SerializeUtils.sizeOfBigInteger();
        size += this.agentAddress.length;
        size += this.rewardAddress.length;
        return size += this.packingAddress.length;
    }

    @Override
    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeBigInteger(this.deposit);
        stream.write(this.agentAddress);
        stream.write(this.packingAddress);
        stream.write(this.rewardAddress);
    }

    @Override
    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.deposit = byteBuffer.readBigInteger();
        this.agentAddress = byteBuffer.readBytes(23);
        this.packingAddress = byteBuffer.readBytes(23);
        this.rewardAddress = byteBuffer.readBytes(23);
    }

    public byte[] getAgentAddress() {
        return this.agentAddress;
    }

    public void setAgentAddress(byte[] agentAddress) {
        this.agentAddress = agentAddress;
    }

    public byte[] getPackingAddress() {
        return this.packingAddress;
    }

    public void setPackingAddress(byte[] packingAddress) {
        this.packingAddress = packingAddress;
    }

    public byte[] getRewardAddress() {
        return this.rewardAddress;
    }

    public void setRewardAddress(byte[] rewardAddress) {
        this.rewardAddress = rewardAddress;
    }

    public BigInteger getDeposit() {
        return this.deposit;
    }

    public void setDeposit(BigInteger deposit) {
        this.deposit = deposit;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public long getBlockHeight() {
        return this.blockHeight;
    }

    public void setBlockHeight(long blockHeight) {
        this.blockHeight = blockHeight;
    }

    public long getDelHeight() {
        return this.delHeight;
    }

    public void setDelHeight(long delHeight) {
        this.delHeight = delHeight;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public double getCreditVal() {
        return this.creditVal;
    }

    public void setCreditVal(double creditVal) {
        this.creditVal = creditVal;
    }

    public NulsHash getTxHash() {
        return this.txHash;
    }

    public void setTxHash(NulsHash txHash) {
        this.txHash = txHash;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public byte[] getPubKey() {
        return this.pubKey;
    }

    public void setPubKey(byte[] pubKey) {
        this.pubKey = pubKey;
    }

    public String getPackingAddressStr() {
        return this.packingAddressStr;
    }

    public void setPackingAddressStr(String packingAddressStr) {
        this.packingAddressStr = packingAddressStr;
    }

    public Agent clone() throws CloneNotSupportedException {
        return (Agent)super.clone();
    }

    public Set<byte[]> getAddresses() {
        HashSet<byte[]> addressSet = new HashSet<byte[]>();
        addressSet.add(this.agentAddress);
        return addressSet;
    }
}

