/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.kit.txdata;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import network.nerve.base.basic.NulsByteBuffer;
import network.nerve.base.basic.NulsOutputStreamBuffer;
import network.nerve.base.data.BaseNulsData;
import network.nerve.base.data.NulsHash;
import network.nerve.core.exception.NulsException;
import network.nerve.core.parse.SerializeUtils;

public class StopAgent
extends BaseNulsData {
    private byte[] address;
    private NulsHash createTxHash;

    @Override
    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeBytesWithLength(this.address);
        stream.write(this.createTxHash.getBytes());
    }

    @Override
    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.address = byteBuffer.readByLengthByte();
        this.createTxHash = byteBuffer.readHash();
    }

    @Override
    public int size() {
        int size = this.createTxHash.getBytes().length;
        return size += SerializeUtils.sizeOfBytes(this.address);
    }

    public Set<byte[]> getAddresses() {
        HashSet<byte[]> addressSet = new HashSet<byte[]>();
        if (null != this.address) {
            addressSet.add(this.address);
        }
        return addressSet;
    }

    public byte[] getAddress() {
        return this.address;
    }

    public void setAddress(byte[] address) {
        this.address = address;
    }

    public NulsHash getCreateTxHash() {
        return this.createTxHash;
    }

    public void setCreateTxHash(NulsHash createTxHash) {
        this.createTxHash = createTxHash;
    }
}

