/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.as2.outbound;

import com.google.inject.Inject;
import com.google.inject.Provider;
import io.opentracing.Span;
import io.opentracing.Tracer;
import network.oxalis.api.lang.OxalisTransmissionException;
import network.oxalis.api.outbound.MessageSender;
import network.oxalis.api.outbound.TransmissionRequest;
import network.oxalis.api.outbound.TransmissionResponse;
import network.oxalis.as2.outbound.As2MessageSender;
import network.oxalis.commons.tracing.Traceable;

class As2MessageSenderFacade
extends Traceable
implements MessageSender {
    private Provider<As2MessageSender> messageSenderProvider;

    @Inject
    public As2MessageSenderFacade(Tracer tracer, Provider<As2MessageSender> messageSenderProvider) {
        super(tracer);
        this.messageSenderProvider = messageSenderProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransmissionResponse send(TransmissionRequest transmissionRequest) throws OxalisTransmissionException {
        Span span = this.tracer.buildSpan(((Object)((Object)this)).getClass().getSimpleName()).start();
        try {
            TransmissionResponse transmissionResponse = this.send(transmissionRequest, span);
            return transmissionResponse;
        }
        finally {
            span.finish();
        }
    }

    public TransmissionResponse send(TransmissionRequest transmissionRequest, Span root) throws OxalisTransmissionException {
        return ((As2MessageSender)((Object)this.messageSenderProvider.get())).send(transmissionRequest, root);
    }
}

