/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.as4.outbound;

import com.google.inject.Inject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import network.oxalis.api.lang.TimestampException;
import network.oxalis.api.model.Direction;
import network.oxalis.api.model.TransmissionIdentifier;
import network.oxalis.api.outbound.TransmissionRequest;
import network.oxalis.api.outbound.TransmissionResponse;
import network.oxalis.api.timestamp.Timestamp;
import network.oxalis.api.timestamp.TimestampProvider;
import network.oxalis.as4.lang.OxalisAs4TransmissionException;
import network.oxalis.as4.outbound.As4TransmissionResponse;
import network.oxalis.as4.util.AS4ErrorCode;
import network.oxalis.as4.util.Marshalling;
import network.oxalis.commons.bouncycastle.BCHelper;
import network.oxalis.vefa.peppol.common.code.DigestMethod;
import network.oxalis.vefa.peppol.common.model.Digest;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.Error;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.SignalMessage;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TransmissionResponseConverter {
    private final JAXBContext jaxbContext = Marshalling.getInstance();
    private final TimestampProvider timestampProvider;

    @Inject
    public TransmissionResponseConverter(TimestampProvider timestampProvider) {
        this.timestampProvider = timestampProvider;
    }

    public TransmissionResponse convert(TransmissionRequest request, SOAPMessage response) throws OxalisAs4TransmissionException {
        SignalMessage signalMessage = this.getSignalMessage(response);
        String refToMessageId = signalMessage.getMessageInfo().getRefToMessageId();
        TransmissionIdentifier ti = TransmissionIdentifier.of((String)refToMessageId);
        if (!signalMessage.getError().isEmpty()) {
            Error error = signalMessage.getError().get(0);
            throw new OxalisAs4TransmissionException(error.getErrorDetail(), AS4ErrorCode.nameOf(error.getErrorCode()), AS4ErrorCode.Severity.nameOf(error.getSeverity()));
        }
        Timestamp ts = this.getTimestamp();
        Digest digest = this.getDigest();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            response.writeTo((OutputStream)bos);
        }
        catch (IOException | SOAPException e) {
            throw new OxalisAs4TransmissionException("Could not write response", e);
        }
        return new As4TransmissionResponse(ti, request, digest, bos.toByteArray(), ts, ts.getDate());
    }

    private Digest getDigest() throws OxalisAs4TransmissionException {
        try {
            MessageDigest md = BCHelper.getMessageDigest((String)"sha256");
            return Digest.of((DigestMethod)DigestMethod.SHA256, (byte[])md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new OxalisAs4TransmissionException("Could not create message digest", (Throwable)e);
        }
    }

    private Timestamp getTimestamp() throws OxalisAs4TransmissionException {
        try {
            return this.timestampProvider.generate(null, Direction.OUT);
        }
        catch (TimestampException e) {
            throw new OxalisAs4TransmissionException("Could not create timestamp", (Throwable)e);
        }
    }

    private SignalMessage getSignalMessage(SOAPMessage soapMessage) throws OxalisAs4TransmissionException {
        Node signalNode = this.getSignalNode(soapMessage);
        try {
            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            return (SignalMessage)unmarshaller.unmarshal(signalNode, SignalMessage.class).getValue();
        }
        catch (JAXBException e) {
            throw new OxalisAs4TransmissionException("Could not create unmarshaller", (Throwable)e);
        }
    }

    private Node getSignalNode(SOAPMessage soapMessage) throws OxalisAs4TransmissionException {
        try {
            NodeList signalNodeList = soapMessage.getSOAPHeader().getElementsByTagNameNS("*", "SignalMessage");
            if (signalNodeList.getLength() != 1) {
                throw new OxalisAs4TransmissionException("SOAP header contains zero or multiple SignalMessage elements, should only contain one");
            }
            return signalNodeList.item(0);
        }
        catch (SOAPException e) {
            throw new OxalisAs4TransmissionException("Could not access response body", (Throwable)e);
        }
    }
}

