package network.oxalis.as4.util;

import lombok.experimental.UtilityClass;

import javax.xml.namespace.QName;

@UtilityClass
public class Constants {

    public static final String EBMS_NAMESPACE = "http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/";

    public static final QName MESSAGING_QNAME = new QName(EBMS_NAMESPACE, "Messaging", "eb");
    public static final QName USER_MESSAGE_QNAME = new QName(EBMS_NAMESPACE, "UserMessage");
    public static final QName SIGNAL_MESSAGE_QNAME = new QName(EBMS_NAMESPACE, "SignalMessage");

    public static final String DIGEST_ALGORITHM_SHA256 = "sha256";

    public static final String TEST_SERVICE = "http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/service";
    public static final String TEST_ACTION = "http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/test";

    public static final String OXALIS_ALGORITHM_NAMESPACE = "http://oxalis.network/custom/security-policy";
    public static final String BASIC_128_GCM_SHA_256 = "Basic128GCMSha256";
    public static final String BASIC_128_GCM_SHA_256_MGF_SHA_256 = "Basic128GCMSha256MgfSha256";
}
