/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.as4.inbound;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import network.oxalis.api.model.TransmissionIdentifier;
import network.oxalis.api.persist.PersisterHandler;
import network.oxalis.as4.inbound.As4PayloadHeader;
import network.oxalis.as4.lang.AS4Error;
import network.oxalis.as4.lang.OxalisAs4Exception;
import network.oxalis.as4.util.AS4ErrorCode;
import network.oxalis.as4.util.As4MessageFactory;
import network.oxalis.as4.util.MessageId;
import network.oxalis.vefa.peppol.common.model.Header;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class As4FaultInHandler
implements SOAPHandler<SOAPMessageContext> {
    private static final Logger log = LoggerFactory.getLogger(As4FaultInHandler.class);
    private final As4MessageFactory as4MessageFactory;
    private final PersisterHandler persisterHandler;

    @Inject
    public As4FaultInHandler(As4MessageFactory as4MessageFactory, PersisterHandler persisterHandler) {
        this.as4MessageFactory = as4MessageFactory;
        this.persisterHandler = persisterHandler;
    }

    public Set<QName> getHeaders() {
        return Collections.emptySet();
    }

    public boolean handleMessage(SOAPMessageContext context) {
        return true;
    }

    public boolean handleFault(SOAPMessageContext context) {
        String messageId = Optional.ofNullable((MessageId)context.get((Object)"oxalis.as4.messageId")).map(MessageId::getValue).orElse(null);
        Exception exception = (Exception)context.get((Object)Exception.class.getName());
        if (exception == null) {
            return true;
        }
        log.info("handleFault for Exception", (Throwable)exception);
        AS4Error as4Error = As4FaultInHandler.toAS4Error(exception);
        this.handleAS4Error(context, messageId, as4Error);
        return true;
    }

    protected void handleAS4Error(SOAPMessageContext context, String messageId, AS4Error as4Error) {
        SOAPMessage errorMessage = this.as4MessageFactory.createErrorMessage(messageId, as4Error);
        context.setMessage(errorMessage);
        Path firstPayloadPath = (Path)context.get((Object)"network.oxalis.as4.first.payload.path");
        As4PayloadHeader firstPayloadHeader = (As4PayloadHeader)((Object)context.get((Object)"network.oxalis.as4.first.payload.header"));
        if (messageId != null && firstPayloadPath != null) {
            try {
                this.persisterHandler.persist(TransmissionIdentifier.of((String)messageId), (Header)firstPayloadHeader, firstPayloadPath, as4Error.getException());
            }
            catch (Exception e) {
                log.error("Unable to persist exception", (Throwable)e);
            }
        }
    }

    public void close(MessageContext context) {
    }

    public static AS4Error toAS4Error(Throwable t) {
        Optional<Message> faultMessage = Optional.ofNullable(PhaseInterceptorChain.getCurrentMessage());
        Optional<Message> inMessage = faultMessage.map(Message::getExchange).map(Exchange::getInMessage);
        if (t instanceof Fault) {
            Fault fault = (Fault)t;
            t = fault.getCause();
        }
        if (t instanceof WebServiceException) {
            WebServiceException webServiceException = (WebServiceException)t;
            t = webServiceException.getCause();
        }
        if (t instanceof WSSecurityException && inMessage.isPresent()) {
            boolean isCompressionError = (Boolean)inMessage.get().getOrDefault((Object)"oxalis.as4.compressionErrorDetected", (Object)false);
            if (isCompressionError) {
                return new OxalisAs4Exception("Content cannot be compressed after signature/encryption", AS4ErrorCode.EBMS_0303);
            }
            return new OxalisAs4Exception(t.getMessage(), t, AS4ErrorCode.EBMS_0009, AS4ErrorCode.Severity.ERROR);
        }
        if (t instanceof AS4Error) {
            return (AS4Error)((Object)t);
        }
        return new OxalisAs4Exception(t.getMessage(), t, AS4ErrorCode.EBMS_0004, AS4ErrorCode.Severity.ERROR);
    }
}

