/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.as4.outbound;

import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;
import network.oxalis.api.outbound.TransmissionRequest;
import network.oxalis.api.outbound.TransmissionResponse;
import network.oxalis.api.settings.Settings;
import network.oxalis.as4.api.MessageIdGenerator;
import network.oxalis.as4.common.MerlinProvider;
import network.oxalis.as4.config.As4Conf;
import network.oxalis.as4.lang.OxalisAs4TransmissionException;
import network.oxalis.as4.outbound.As4TransmissionRequest;
import network.oxalis.as4.outbound.BrowserTypeProvider;
import network.oxalis.as4.outbound.LoggingBeforeSecurityInInterceptor;
import network.oxalis.as4.outbound.MessagingProvider;
import network.oxalis.as4.outbound.TransmissionResponseConverter;
import network.oxalis.as4.util.CompressionUtil;
import network.oxalis.as4.util.Constants;
import network.oxalis.as4.util.PolicyService;
import network.oxalis.commons.http.HttpConf;
import network.oxalis.commons.security.KeyStoreConf;
import org.apache.cxf.attachment.AttachmentUtil;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.ext.logging.LoggingFeature;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxws.DispatchImpl;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.ws.policy.WSPolicyFeature;
import org.apache.neethi.Policy;
import org.apache.wss4j.common.crypto.Merlin;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.Messaging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class As4MessageSender {
    private static final Logger log = LoggerFactory.getLogger(As4MessageSender.class);
    public static final QName SERVICE_NAME = new QName("oxalis.network/", "outbound-service");
    public static final QName PORT_NAME = new QName("oxalis.network/", "port");
    private final MessagingProvider messagingProvider;
    private final MessageIdGenerator messageIdGenerator;
    private final Settings<KeyStoreConf> settings;
    private final Settings<As4Conf> as4settings;
    private final CompressionUtil compressionUtil;
    private final Settings<HttpConf> httpConfSettings;
    private final TransmissionResponseConverter transmissionResponseConverter;
    private final MerlinProvider merlinProvider;
    private final PolicyService policyService;
    private final String browserType;

    @Inject
    public As4MessageSender(MessagingProvider messagingProvider, MessageIdGenerator messageIdGenerator, Settings<KeyStoreConf> settings, Settings<As4Conf> as4settings, CompressionUtil compressionUtil, Settings<HttpConf> httpConfSettings, TransmissionResponseConverter transmissionResponseConverter, MerlinProvider merlinProvider, PolicyService policyService, BrowserTypeProvider browserTypeProvider) {
        this.messagingProvider = messagingProvider;
        this.messageIdGenerator = messageIdGenerator;
        this.settings = settings;
        this.as4settings = as4settings;
        this.compressionUtil = compressionUtil;
        this.httpConfSettings = httpConfSettings;
        this.transmissionResponseConverter = transmissionResponseConverter;
        this.merlinProvider = merlinProvider;
        this.policyService = policyService;
        this.browserType = browserTypeProvider.getBrowserType();
    }

    /*
     * Exception decompiling
     */
    public TransmissionResponse send(TransmissionRequest request) throws OxalisAs4TransmissionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private TransmissionResponse invoke(TransmissionRequest request, DispatchImpl<SOAPMessage> dispatch) throws OxalisAs4TransmissionException {
        try {
            SOAPMessage response = (SOAPMessage)dispatch.invoke(null);
            return this.transmissionResponseConverter.convert(request, response);
        }
        catch (Exception e) {
            throw new OxalisAs4TransmissionException("Failed to send message", (Throwable)e);
        }
    }

    private SoapHeader getSoapHeader(Messaging messaging) throws OxalisAs4TransmissionException {
        try {
            JAXBDataBinding binding = new JAXBDataBinding(new Class[]{Messaging.class});
            return new SoapHeader(Constants.MESSAGING_QNAME, (Object)messaging, (DataBinding)binding, true);
        }
        catch (JAXBException e) {
            throw new OxalisAs4TransmissionException("Unable to marshal AS4 header", (Throwable)e);
        }
    }

    private void configureSecurity(TransmissionRequest request, Dispatch<SOAPMessage> dispatch) {
        Merlin merlin = this.merlinProvider.getMerlin();
        dispatch.getRequestContext().put("security.signature.crypto", merlin);
        dispatch.getRequestContext().put("security.signature.password", this.settings.getString((Object)KeyStoreConf.KEY_PASSWORD));
        dispatch.getRequestContext().put("security.signature.username", this.settings.getString((Object)KeyStoreConf.KEY_ALIAS));
        dispatch.getRequestContext().put("security.encryption.certificate", request.getEndpoint().getCertificate());
        dispatch.getRequestContext().put("ws-security.swa.encryption.attachment.transform.content", true);
    }

    public AttachmentHolder prepareAttachment(TransmissionRequest request) throws OxalisAs4TransmissionException {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        headers.put("Content-ID", Collections.singletonList(this.getContentID(request)));
        headers.put("CompressionType", Collections.singletonList("application/gzip"));
        headers.put("MimeType", Collections.singletonList("application/xml"));
        try {
            InputStream compressedStream = this.compressionUtil.getCompressedStream(request.getPayload());
            Attachment attachment = AttachmentUtil.createAttachment((InputStream)compressedStream, headers);
            return new AttachmentHolder(compressedStream, attachment);
        }
        catch (IOException e) {
            throw new OxalisAs4TransmissionException("Unable to compress payload", (Throwable)e);
        }
    }

    private String getContentID(TransmissionRequest request) {
        if (request instanceof As4TransmissionRequest) {
            As4TransmissionRequest as4request = (As4TransmissionRequest)request;
            return as4request.getPayloadHref();
        }
        return this.messageIdGenerator.generate();
    }

    private DispatchImpl<SOAPMessage> createDispatch(TransmissionRequest request) throws OxalisAs4TransmissionException {
        DispatchImpl dispatch = (DispatchImpl)this.getService(request).createDispatch(PORT_NAME, SOAPMessage.class, Service.Mode.MESSAGE);
        dispatch.getRequestContext().put("javax.xml.ws.service.endpoint.address", request.getEndpoint().getAddress().toString());
        this.configureSecurity(request, (Dispatch<SOAPMessage>)dispatch);
        Client client = dispatch.getClient();
        if ("cef-conformance".equalsIgnoreCase(this.as4settings.getString((Object)As4Conf.TYPE))) {
            client.getInInterceptors().add(this.getLoggingBeforeSecurityInInterceptor());
        }
        HTTPConduit httpConduit = (HTTPConduit)client.getConduit();
        HTTPClientPolicy httpClientPolicy = httpConduit.getClient();
        httpClientPolicy.setConnectionTimeout((long)this.httpConfSettings.getInt((Object)HttpConf.TIMEOUT_CONNECT));
        httpClientPolicy.setReceiveTimeout((long)this.httpConfSettings.getInt((Object)HttpConf.TIMEOUT_READ));
        httpClientPolicy.setAllowChunking(true);
        httpClientPolicy.setChunkLength(8192);
        httpClientPolicy.setBrowserType(this.browserType);
        return dispatch;
    }

    private LoggingBeforeSecurityInInterceptor getLoggingBeforeSecurityInInterceptor() {
        LoggingBeforeSecurityInInterceptor interceptor = new LoggingBeforeSecurityInInterceptor();
        interceptor.setPrettyLogging(true);
        interceptor.setLogMultipart(true);
        return interceptor;
    }

    private Service getService(TransmissionRequest request) throws OxalisAs4TransmissionException {
        Service service = Service.create((QName)SERVICE_NAME, (WebServiceFeature[])new WebServiceFeature[]{new LoggingFeature(), new WSPolicyFeature(new Policy[]{this.policyService.getPolicy(request)})});
        service.addPort(PORT_NAME, "http://www.w3.org/2003/05/soap/bindings/HTTP/", request.getEndpoint().getAddress().toString());
        return service;
    }

    private static class AttachmentHolder {
        private final InputStream inputStream;
        private final Attachment attachment;

        public AttachmentHolder(InputStream inputStream, Attachment attachment) {
            this.inputStream = inputStream;
            this.attachment = attachment;
        }

        static /* synthetic */ Attachment access$000(AttachmentHolder x0) {
            return x0.attachment;
        }

        static /* synthetic */ InputStream access$100(AttachmentHolder x0) {
            return x0.inputStream;
        }
    }
}

