/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.as4.util;

import network.oxalis.as4.util.OxalisAssertionBuilder;
import org.apache.cxf.Bus;
import org.apache.cxf.ws.policy.AssertionBuilderRegistry;
import org.apache.cxf.ws.security.policy.custom.AlgorithmSuiteLoader;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.neethi.builders.AssertionBuilder;
import org.apache.wss4j.policy.SPConstants;
import org.apache.wss4j.policy.model.AbstractSecurityAssertion;
import org.apache.wss4j.policy.model.AlgorithmSuite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OxalisAlgorithmSuiteLoader
implements AlgorithmSuiteLoader {
    private static final Logger log = LoggerFactory.getLogger(OxalisAlgorithmSuiteLoader.class);
    public static final String AES128_GCM_ALGORITHM = "http://www.w3.org/2009/xmlenc11#aes128-gcm";

    public OxalisAlgorithmSuiteLoader(Bus bus) {
        bus.setExtension((Object)this, AlgorithmSuiteLoader.class);
        this.register(bus);
    }

    public AlgorithmSuite getAlgorithmSuite(Bus bus, SPConstants.SPVersion version, Policy nestedPolicy) {
        return new OxalisAlgorithmSuite(version, nestedPolicy);
    }

    private void register(Bus bus) {
        AssertionBuilderRegistry reg = (AssertionBuilderRegistry)bus.getExtension(AssertionBuilderRegistry.class);
        if (reg != null) {
            reg.registerBuilder((AssertionBuilder)new OxalisAssertionBuilder());
        }
    }

    public static class OxalisAlgorithmSuite
    extends AlgorithmSuite {
        OxalisAlgorithmSuite(SPConstants.SPVersion version, Policy nestedPolicy) {
            super(version, nestedPolicy);
            this.setAsymmetricSignature("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        }

        protected AbstractSecurityAssertion cloneAssertion(Policy nestedPolicy) {
            return new OxalisAlgorithmSuite(this.getVersion(), nestedPolicy);
        }

        protected void parseCustomAssertion(Assertion assertion) {
            String assertionName = assertion.getName().getLocalPart();
            String assertionNamespace = assertion.getName().getNamespaceURI();
            if (!"http://oxalis.network/custom/security-policy".equals(assertionNamespace)) {
                return;
            }
            if ("Basic128GCMSha256".equals(assertionName)) {
                this.setAlgorithmSuiteType((AlgorithmSuite.AlgorithmSuiteType)ALGORITHM_SUITE_TYPES.get("Basic128GCMSha256"));
                this.getAlgorithmSuiteType().setNamespace(assertionNamespace);
            } else if ("Basic128GCMSha256MgfSha256".equals(assertionName)) {
                this.setAlgorithmSuiteType((AlgorithmSuite.AlgorithmSuiteType)ALGORITHM_SUITE_TYPES.get("Basic128GCMSha256MgfSha256"));
                this.getAlgorithmSuiteType().setNamespace(assertionNamespace);
            }
        }

        static {
            ALGORITHM_SUITE_TYPES.put("Basic128GCMSha256", new AlgorithmSuite.AlgorithmSuiteType("Basic128GCMSha256", "http://www.w3.org/2001/04/xmlenc#sha256", OxalisAlgorithmSuiteLoader.AES128_GCM_ALGORITHM, "http://www.w3.org/2001/04/xmlenc#kw-aes128", "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", 128, 128, 128, 256, 1024, 4096));
            ALGORITHM_SUITE_TYPES.put("Basic128GCMSha256MgfSha256", new AlgorithmSuite.AlgorithmSuiteType("Basic128GCMSha256MgfSha256", "http://www.w3.org/2001/04/xmlenc#sha256", OxalisAlgorithmSuiteLoader.AES128_GCM_ALGORITHM, "http://www.w3.org/2001/04/xmlenc#kw-aes128", "http://www.w3.org/2009/xmlenc11#rsa-oaep", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", 128, 128, 128, 256, 1024, 4096));
            ((AlgorithmSuite.AlgorithmSuiteType)ALGORITHM_SUITE_TYPES.get("Basic128GCMSha256MgfSha256")).setMGFAlgo("http://www.w3.org/2009/xmlenc11#mgf1sha256");
            ((AlgorithmSuite.AlgorithmSuiteType)ALGORITHM_SUITE_TYPES.get("Basic128GCMSha256MgfSha256")).setEncryptionDigest("http://www.w3.org/2001/04/xmlenc#sha256");
        }
    }
}

