/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.as4.outbound;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import network.oxalis.as4.inbound.OxalisAS4Version;
import network.oxalis.commons.util.OxalisVersion;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class BrowserTypeProvider {
    private static final Logger log = LoggerFactory.getLogger(BrowserTypeProvider.class);
    private final X509Certificate certificate;

    @Inject
    public BrowserTypeProvider(X509Certificate certificate) {
        this.certificate = certificate;
    }

    public String getBrowserType() {
        return String.format("Oxalis %s / AS4 %s / %s", OxalisVersion.getVersion(), OxalisAS4Version.getVersion(), this.getCN());
    }

    private String getCN() {
        try {
            X500Name x500name = new JcaX509CertificateHolder(this.certificate).getSubject();
            RDN cn = x500name.getRDNs(BCStyle.CN)[0];
            return IETFUtils.valueToString((ASN1Encodable)cn.getFirst().getValue());
        }
        catch (CertificateEncodingException e) {
            log.warn("Could not extract CN from certificate", (Throwable)e);
            return "Unknown";
        }
    }
}

