/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.as4.inbound;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.BindingType;
import javax.xml.ws.Provider;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceProvider;
import javax.xml.ws.handler.MessageContext;
import network.oxalis.as4.inbound.As4InboundHandler;
import network.oxalis.as4.lang.OxalisAs4Exception;

@WebServiceProvider
@ServiceMode(value=Service.Mode.MESSAGE)
@BindingType(value="http://www.w3.org/2003/05/soap/bindings/HTTP/")
@Singleton
public class As4Provider
implements Provider<SOAPMessage> {
    @Resource
    private WebServiceContext context;
    @Inject
    private As4InboundHandler handler;

    public SOAPMessage invoke(SOAPMessage request) {
        MessageContext messageContext = this.context.getMessageContext();
        HttpServletResponse httpRes = (HttpServletResponse)messageContext.get((Object)"HTTP.RESPONSE");
        httpRes.setStatus(200);
        try {
            return this.handler.handle(request, messageContext);
        }
        catch (OxalisAs4Exception e) {
            httpRes.setStatus(400);
            throw new WebServiceException((Throwable)((Object)e));
        }
    }
}

