/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.as4.util;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import network.oxalis.as4.api.MessageIdGenerator;
import network.oxalis.as4.inbound.ProsessingContext;
import network.oxalis.as4.lang.AS4Error;
import network.oxalis.as4.lang.OxalisAs4Exception;
import network.oxalis.as4.util.AS4ErrorCode;
import network.oxalis.as4.util.Constants;
import network.oxalis.as4.util.Marshalling;
import network.oxalis.as4.util.XMLUtil;
import org.apache.cxf.interceptor.Fault;
import org.oasis_open.docs.ebxml_bp.ebbp_signals_2.MessagePartNRInformation;
import org.oasis_open.docs.ebxml_bp.ebbp_signals_2.NonRepudiationInformation;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.Error;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.MessageInfo;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.Receipt;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.SignalMessage;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.UserMessage;
import org.w3.xmldsig.ReferenceType;
import org.w3c.dom.Node;

@Singleton
public class As4MessageFactory {
    private final MessageIdGenerator messageIdGenerator;
    private final MessageFactory messageFactory;
    private final JAXBContext jaxbContext;

    @Inject
    public As4MessageFactory(MessageIdGenerator messageIdGenerator) throws SOAPException {
        this(messageIdGenerator, MessageFactory.newInstance((String)"SOAP 1.2 Protocol"), Marshalling.getInstance());
    }

    public As4MessageFactory(MessageIdGenerator messageIdGenerator, MessageFactory messageFactory, JAXBContext jaxbContext) {
        this.messageFactory = messageFactory;
        this.jaxbContext = jaxbContext;
        this.messageIdGenerator = messageIdGenerator;
    }

    public SOAPMessage createReceiptMessage(UserMessage inUserMessage, ProsessingContext prosessingContext) throws OxalisAs4Exception {
        XMLGregorianCalendar xmlGc = XMLUtil.dateToXMLGeorgianCalendar(prosessingContext.getReceiptTimestamp().getDate());
        MessageInfo messageInfo = MessageInfo.builder().withTimestamp(xmlGc).withMessageId(this.messageIdGenerator.generate()).withRefToMessageId(inUserMessage.getMessageInfo().getMessageId()).build();
        List mpList = prosessingContext.getReferenceList().stream().map(reference -> MessagePartNRInformation.builder().withReference((ReferenceType)reference).build()).collect(Collectors.toList());
        NonRepudiationInformation nri = NonRepudiationInformation.builder().addMessagePartNRInformation(mpList).build();
        SignalMessage signalMessage = SignalMessage.builder().withMessageInfo(messageInfo).withReceipt(Receipt.builder().withAny(nri).build()).build();
        return this.marshalSignalMessage(signalMessage);
    }

    public SOAPMessage createErrorMessage(String messageId, AS4Error as4Error) {
        try {
            XMLGregorianCalendar currentDate = XMLUtil.dateToXMLGeorgianCalendar(new Date());
            MessageInfo messageInfo = MessageInfo.builder().withRefToMessageId(messageId).withTimestamp(currentDate).withMessageId(this.messageIdGenerator.generate()).build();
            Error error = Error.builder().withRefToMessageInError(messageId).withErrorCode(as4Error.getErrorCode().toString()).withErrorDetail(this.getErrorDetail(as4Error)).withShortDescription(as4Error.getErrorCode().getShortDescription()).withOrigin(as4Error.getErrorCode().getOrigin().toString()).withCategory(as4Error.getErrorCode().getCatgory().toString()).withSeverity(as4Error.getSeverity().toString()).build();
            SignalMessage signalMessage = SignalMessage.builder().withMessageInfo(messageInfo).withError(error).build();
            return this.marshalSignalMessage(signalMessage);
        }
        catch (OxalisAs4Exception e) {
            throw new Fault(e.getCause());
        }
    }

    private String getErrorDetail(AS4Error as4Error) {
        StringBuilder sb = new StringBuilder();
        sb.append(as4Error.getMessage());
        Throwable throwable = as4Error.getException();
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
            sb.append("\ncause: ").append(throwable.getMessage());
        }
        return sb.toString();
    }

    public SOAPMessage marshalSignalMessage(SignalMessage signalMessage) throws OxalisAs4Exception {
        try {
            SOAPMessage message = this.messageFactory.createMessage();
            SOAPHeader soapHeader = message.getSOAPHeader();
            SOAPHeaderElement messagingHeader = soapHeader.addHeaderElement(Constants.MESSAGING_QNAME);
            messagingHeader.setMustUnderstand(true);
            JAXBElement userMessageJAXBElement = new JAXBElement(Constants.SIGNAL_MESSAGE_QNAME, SignalMessage.class, (Object)signalMessage);
            this.jaxbContext.createMarshaller().marshal((Object)userMessageJAXBElement, (Node)messagingHeader);
            return message;
        }
        catch (Exception e) {
            throw new OxalisAs4Exception("Unable to marshal SignalMessage", e, AS4ErrorCode.EBMS_0004);
        }
    }
}

