/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.as4.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CacheSizeExceededException;
import org.apache.cxf.io.CachedOutputStream;

public class CompressionUtil {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getCompressedStream(InputStream sourceStream) throws IOException {
        if (sourceStream == null) {
            throw new IllegalArgumentException("Source Stream cannot be NULL");
        }
        CachedOutputStream cache = new CachedOutputStream();
        try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream((OutputStream)cache);){
            IOUtils.copyAndCloseInput((InputStream)sourceStream, (OutputStream)gzipOutputStream);
            gzipOutputStream.flush();
            gzipOutputStream.finish();
            InputStream inputStream = cache.getInputStream();
            return inputStream;
        }
        catch (IOException | CacheSizeExceededException cee) {
            sourceStream.close();
            throw cee;
        }
    }
}

