/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.as4.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.ws.policy.AssertionBuilderRegistry;
import org.apache.cxf.ws.policy.builder.primitive.PrimitiveAssertion;
import org.apache.cxf.ws.policy.builder.primitive.PrimitiveAssertionBuilder;
import org.apache.cxf.ws.security.policy.custom.AlgorithmSuiteLoader;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.builders.AssertionBuilder;
import org.apache.neethi.builders.xml.XMLPrimitiveAssertionBuilder;
import org.apache.wss4j.policy.SPConstants;
import org.apache.wss4j.policy.model.AbstractSecurityAssertion;
import org.apache.wss4j.policy.model.AlgorithmSuite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class OxalisAlgorithmSuiteLoader
implements AlgorithmSuiteLoader {
    private static final Logger log = LoggerFactory.getLogger(OxalisAlgorithmSuiteLoader.class);
    public static final String OXALIS_ALGORITHM_NAMESPACE = "http://oxalis.network/custom/security-policy";
    public static final String AES128_GCM_ALGORITHM = "http://www.w3.org/2009/xmlenc11#aes128-gcm";
    public static final String BASIC_128_GCM_SHA_256 = "Basic128GCMSha256";
    public static final String BASIC_128_GCM_SHA_256_MGF_SHA_256 = "Basic128GCMSha256MgfSha256";
    private static final Map<String, Bus> BUS_MAP = new ConcurrentHashMap<String, Bus>();

    public OxalisAlgorithmSuiteLoader(Bus bus) {
        BUS_MAP.computeIfAbsent(bus.getId(), id -> {
            AlgorithmSuiteLoader algorithmSuiteLoader = (AlgorithmSuiteLoader)bus.getExtension(AlgorithmSuiteLoader.class);
            if (algorithmSuiteLoader instanceof OxalisAlgorithmSuiteLoader) {
                log.info("Cached OxalisAlgorithmSuite on bus {}", (Object)bus.getId());
            } else {
                log.info("Registering OxalisAlgorithmSuite on bus {}", (Object)bus.getId());
                bus.setExtension((Object)this, AlgorithmSuiteLoader.class);
                this.register(bus);
            }
            return bus;
        });
    }

    public AlgorithmSuite getAlgorithmSuite(Bus bus, SPConstants.SPVersion version, Policy nestedPolicy) {
        return new OxalisAlgorithmSuite(version, nestedPolicy);
    }

    private void register(Bus bus) {
        AssertionBuilderRegistry reg = (AssertionBuilderRegistry)bus.getExtension(AssertionBuilderRegistry.class);
        if (reg != null) {
            final HashMap<QName, PrimitiveAssertion> assertions = new HashMap<QName, PrimitiveAssertion>();
            QName qName = new QName(OXALIS_ALGORITHM_NAMESPACE, BASIC_128_GCM_SHA_256);
            assertions.put(qName, new PrimitiveAssertion(qName));
            qName = new QName(OXALIS_ALGORITHM_NAMESPACE, BASIC_128_GCM_SHA_256_MGF_SHA_256);
            assertions.put(qName, new PrimitiveAssertion(qName));
            reg.registerBuilder((AssertionBuilder)new PrimitiveAssertionBuilder(assertions.keySet()){

                public Assertion build(Element element, AssertionBuilderFactory fact) {
                    if (XMLPrimitiveAssertionBuilder.isOptional((Element)element) || XMLPrimitiveAssertionBuilder.isIgnorable((Element)element)) {
                        return super.build(element, fact);
                    }
                    QName q = new QName(element.getNamespaceURI(), element.getLocalName());
                    return (Assertion)assertions.get(q);
                }
            });
        }
    }

    public static class OxalisAlgorithmSuite
    extends AlgorithmSuite {
        OxalisAlgorithmSuite(SPConstants.SPVersion version, Policy nestedPolicy) {
            super(version, nestedPolicy);
        }

        protected AbstractSecurityAssertion cloneAssertion(Policy nestedPolicy) {
            return new OxalisAlgorithmSuite(this.getVersion(), nestedPolicy);
        }

        protected void parseCustomAssertion(Assertion assertion) {
            String assertionName = assertion.getName().getLocalPart();
            String assertionNamespace = assertion.getName().getNamespaceURI();
            if (!OxalisAlgorithmSuiteLoader.OXALIS_ALGORITHM_NAMESPACE.equals(assertionNamespace)) {
                return;
            }
            if (OxalisAlgorithmSuiteLoader.BASIC_128_GCM_SHA_256.equals(assertionName)) {
                this.setAlgorithmSuiteType((AlgorithmSuite.AlgorithmSuiteType)ALGORITHM_SUITE_TYPES.get(OxalisAlgorithmSuiteLoader.BASIC_128_GCM_SHA_256));
                this.getAlgorithmSuiteType().setNamespace(assertionNamespace);
                this.getAlgorithmSuiteType().setAsymmetricSignature("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
            } else if (OxalisAlgorithmSuiteLoader.BASIC_128_GCM_SHA_256_MGF_SHA_256.equals(assertionName)) {
                this.setAlgorithmSuiteType((AlgorithmSuite.AlgorithmSuiteType)ALGORITHM_SUITE_TYPES.get(OxalisAlgorithmSuiteLoader.BASIC_128_GCM_SHA_256_MGF_SHA_256));
                this.getAlgorithmSuiteType().setNamespace(assertionNamespace);
                this.getAlgorithmSuiteType().setAsymmetricSignature("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
            }
        }

        static {
            ALGORITHM_SUITE_TYPES.put(OxalisAlgorithmSuiteLoader.BASIC_128_GCM_SHA_256, new AlgorithmSuite.AlgorithmSuiteType(OxalisAlgorithmSuiteLoader.BASIC_128_GCM_SHA_256, "http://www.w3.org/2001/04/xmlenc#sha256", OxalisAlgorithmSuiteLoader.AES128_GCM_ALGORITHM, "http://www.w3.org/2001/04/xmlenc#kw-aes128", "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", 128, 128, 128, 256, 1024, 4096));
            ALGORITHM_SUITE_TYPES.put(OxalisAlgorithmSuiteLoader.BASIC_128_GCM_SHA_256_MGF_SHA_256, new AlgorithmSuite.AlgorithmSuiteType(OxalisAlgorithmSuiteLoader.BASIC_128_GCM_SHA_256_MGF_SHA_256, "http://www.w3.org/2001/04/xmlenc#sha256", OxalisAlgorithmSuiteLoader.AES128_GCM_ALGORITHM, "http://www.w3.org/2001/04/xmlenc#kw-aes128", "http://www.w3.org/2009/xmlenc11#rsa-oaep", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", 128, 128, 128, 256, 1024, 4096));
            ((AlgorithmSuite.AlgorithmSuiteType)ALGORITHM_SUITE_TYPES.get(OxalisAlgorithmSuiteLoader.BASIC_128_GCM_SHA_256_MGF_SHA_256)).setMGFAlgo("http://www.w3.org/2009/xmlenc11#mgf1sha256");
            ((AlgorithmSuite.AlgorithmSuiteType)ALGORITHM_SUITE_TYPES.get(OxalisAlgorithmSuiteLoader.BASIC_128_GCM_SHA_256_MGF_SHA_256)).setEncryptionDigest("http://www.w3.org/2001/04/xmlenc#sha256");
        }
    }
}

