/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.as4.inbound;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import network.oxalis.as4.util.Constants;
import network.oxalis.as4.util.Marshalling;
import network.oxalis.as4.util.PolicyService;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.headers.Header;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.neethi.Policy;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.Messaging;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.UserMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

abstract class AbstractSetPolicyInterceptor
extends AbstractSoapInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AbstractSetPolicyInterceptor.class);
    private final JAXBContext jaxbContext = Marshalling.getInstance();
    private final PolicyService policyService;

    public AbstractSetPolicyInterceptor(String phase, PolicyService policyService) {
        super(phase);
        this.policyService = policyService;
    }

    public void handleMessage(SoapMessage message) throws Fault {
        message.put("ws-security.swa.encryption.attachment.transform.content", (Object)true);
        Optional userMessage = this.getMessaging((Message)message).map(Messaging::getUserMessage).map(Collection::stream).orElseGet(Stream::empty).findFirst();
        try {
            Policy policy = userMessage.isPresent() ? this.policyService.getPolicy(((UserMessage)userMessage.get()).getCollaborationInfo()) : this.policyService.getPolicy();
            message.put("org.apache.cxf.ws.policy.override", (Object)policy);
        }
        catch (Exception e) {
            throw new Fault((Throwable)e);
        }
    }

    private Optional<Messaging> getMessaging(Message message) {
        SoapMessage soapMessage = (SoapMessage)message;
        Header header = soapMessage.getHeader(Constants.MESSAGING_QNAME);
        if (header == null) {
            return Optional.empty();
        }
        try {
            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            Messaging messaging = (Messaging)unmarshaller.unmarshal((Node)header.getObject(), Messaging.class).getValue();
            return Optional.of(messaging);
        }
        catch (JAXBException e) {
            throw new Fault((Throwable)e);
        }
    }
}

