/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.as4.outbound;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.stream.Collectors;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import network.oxalis.api.outbound.TransmissionRequest;
import network.oxalis.as4.api.MessageIdGenerator;
import network.oxalis.as4.common.As4MessageProperties;
import network.oxalis.as4.outbound.ActionProvider;
import network.oxalis.as4.outbound.As4TransmissionRequest;
import network.oxalis.as4.util.GeneralUtils;
import network.oxalis.as4.util.PeppolConfiguration;
import network.oxalis.as4.util.TransmissionRequestUtil;
import network.oxalis.commons.security.CertificateUtils;
import network.oxalis.vefa.peppol.common.model.ProcessIdentifier;
import org.apache.cxf.attachment.AttachmentUtil;
import org.apache.cxf.message.Attachment;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.AgreementRef;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.CollaborationInfo;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.From;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.MessageInfo;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.MessageProperties;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.Messaging;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.PartInfo;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.PartProperties;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.PartyId;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.PartyInfo;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.PayloadInfo;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.Property;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.Service;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.To;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.UserMessage;

public class MessagingProvider {
    private final X509Certificate certificate;
    private final MessageIdGenerator messageIdGenerator;
    private final PeppolConfiguration defaultOutboundConfiguration;
    private final ActionProvider actionProvider;

    @Inject
    public MessagingProvider(X509Certificate certificate, MessageIdGenerator messageIdGenerator, PeppolConfiguration defaultOutboundConfiguration, ActionProvider actionProvider) {
        this.certificate = certificate;
        this.messageIdGenerator = messageIdGenerator;
        this.defaultOutboundConfiguration = defaultOutboundConfiguration;
        this.actionProvider = actionProvider;
    }

    public Messaging createMessagingHeader(TransmissionRequest request, Collection<Attachment> attachments) {
        return Messaging.builder().addUserMessage(this.getUserMessage(request, attachments)).build();
    }

    public UserMessage getUserMessage(TransmissionRequest request, Collection<Attachment> attachments) {
        return UserMessage.builder().withMessageInfo(this.createMessageInfo(request)).withPartyInfo(this.createPartyInfo(request)).withCollaborationInfo(this.createCollaborationInfo(request)).withMessageProperties(this.createMessageProperties(request)).withPayloadInfo(this.createPayloadInfo(request, attachments)).build();
    }

    private PayloadInfo createPayloadInfo(TransmissionRequest request, Collection<Attachment> attachments) {
        ArrayList partInfos = Lists.newArrayList();
        for (Attachment attachment : attachments) {
            PartProperties.Builder<Void> partProperties = PartProperties.builder();
            String cid = "cid:" + AttachmentUtil.cleanContentId((String)attachment.getId());
            GeneralUtils.iteratorToStreamOfUnknownSize(attachment.getHeaderNames(), 16, false).filter(header -> !"Content-ID".equals(header)).map(header -> Property.builder().withName((String)header).withValue(attachment.getHeader(header)).build()).forEach(xva$0 -> partProperties.addProperty((Property)xva$0));
            if (request instanceof As4TransmissionRequest) {
                As4TransmissionRequest as4TransmissionRequest = (As4TransmissionRequest)request;
                if (null != as4TransmissionRequest.getPayloadCharset()) {
                    partProperties.addProperty(Property.builder().withName("CharacterSet").withValue(as4TransmissionRequest.getPayloadCharset().name().toLowerCase()).build());
                }
                if (null != as4TransmissionRequest.getCompressionType()) {
                    partProperties.addProperty(Property.builder().withName("CompressionType").withValue(as4TransmissionRequest.getCompressionType()).build());
                }
            }
            PartInfo partInfo = PartInfo.builder().withHref(cid).withPartProperties(partProperties.build()).build();
            partInfos.add(partInfo);
        }
        return PayloadInfo.builder().withPartInfo(partInfos).build();
    }

    private MessageProperties createMessageProperties(TransmissionRequest request) {
        As4TransmissionRequest as4TransmissionRequest;
        As4MessageProperties properties = new As4MessageProperties();
        if (request instanceof As4TransmissionRequest && (as4TransmissionRequest = (As4TransmissionRequest)request).getMessageProperties() != null) {
            properties.addAll(as4TransmissionRequest.getMessageProperties());
        }
        if (properties.isMissing("originalSender")) {
            properties.add(TransmissionRequestUtil.toAs4MessageProperty("originalSender", request.getHeader().getSender()));
        }
        if (properties.isMissing("finalRecipient")) {
            properties.add(TransmissionRequestUtil.toAs4MessageProperty("finalRecipient", request.getHeader().getReceiver()));
        }
        return MessageProperties.builder().withProperty(properties.stream().map(p -> Property.builder().withName(p.getName()).withType(p.getType()).withValue(p.getValue()).build()).collect(Collectors.toList())).build();
    }

    private PartyInfo createPartyInfo(TransmissionRequest request) {
        String fromName = CertificateUtils.extractCommonName((X509Certificate)this.certificate);
        String toName = CertificateUtils.extractCommonName((X509Certificate)request.getEndpoint().getCertificate());
        PeppolConfiguration outboundConfiguration = request.getTag() instanceof PeppolConfiguration ? (PeppolConfiguration)request.getTag() : this.defaultOutboundConfiguration;
        return PartyInfo.builder().withFrom(From.builder().withPartyId(PartyId.builder().withType(outboundConfiguration.getPartyIDType()).withValue(fromName).build()).withRole(outboundConfiguration.getFromRole()).build()).withTo(To.builder().withPartyId(PartyId.builder().withType(outboundConfiguration.getPartyIDType()).withValue(toName).build()).withRole(outboundConfiguration.getToRole()).build()).build();
    }

    public CollaborationInfo createCollaborationInfo(TransmissionRequest request) {
        String action = this.actionProvider.getAction(request.getHeader().getDocumentType());
        ProcessIdentifier process = request.getHeader().getProcess();
        CollaborationInfo.Builder<Void> cib = CollaborationInfo.builder().withConversationId(this.getConversationId(request)).withAction(action).withService(Service.builder().withType(process.getScheme().getIdentifier()).withValue(process.getIdentifier()).build());
        if (request instanceof As4TransmissionRequest && ((As4TransmissionRequest)request).isPing()) {
            cib = cib.withAction("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/test").withService(Service.builder().withValue("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/service").build());
        }
        if (this.defaultOutboundConfiguration.getAgreementRef() != null) {
            cib = cib.withAgreementRef(AgreementRef.builder().withValue(this.defaultOutboundConfiguration.getAgreementRef()).build());
        }
        return cib.build();
    }

    private MessageInfo createMessageInfo(TransmissionRequest request) {
        As4TransmissionRequest as4TransmissionRequest;
        XMLGregorianCalendar xmlDate;
        GregorianCalendar gcal = GregorianCalendar.from(LocalDateTime.now().atZone(ZoneId.systemDefault()));
        try {
            xmlDate = DatatypeFactory.newInstance().newXMLGregorianCalendar(gcal);
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException("Error getting xml date", e);
        }
        MessageInfo.Builder<Void> builder = MessageInfo.builder().withMessageId(this.getMessageId(request)).withTimestamp(xmlDate);
        if (request instanceof As4TransmissionRequest && (as4TransmissionRequest = (As4TransmissionRequest)request).getRefToMessageId() != null) {
            builder.withRefToMessageId(as4TransmissionRequest.getRefToMessageId());
        }
        return builder.build();
    }

    private String getMessageId(TransmissionRequest request) {
        String messageId = null;
        if (request instanceof As4TransmissionRequest) {
            As4TransmissionRequest as4TransmissionRequest = (As4TransmissionRequest)request;
            messageId = as4TransmissionRequest.getMessageId();
        }
        return messageId != null ? messageId : this.newId();
    }

    private String getConversationId(TransmissionRequest request) {
        String conversationId = null;
        if (request instanceof As4TransmissionRequest) {
            As4TransmissionRequest as4TransmissionRequest = (As4TransmissionRequest)request;
            conversationId = as4TransmissionRequest.getConversationId();
        }
        return conversationId != null ? conversationId : this.newId();
    }

    private String newId() {
        return this.messageIdGenerator.generate();
    }
}

