/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.as4.util;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.soap.MessageFactory;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPHeader;
import jakarta.xml.soap.SOAPHeaderElement;
import jakarta.xml.soap.SOAPMessage;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.datatype.XMLGregorianCalendar;
import network.oxalis.as4.api.MessageIdGenerator;
import network.oxalis.as4.inbound.ProsessingContext;
import network.oxalis.as4.lang.AS4Error;
import network.oxalis.as4.lang.OxalisAs4Exception;
import network.oxalis.as4.util.AS4ErrorCode;
import network.oxalis.as4.util.Constants;
import network.oxalis.as4.util.Marshalling;
import network.oxalis.as4.util.XMLUtil;
import org.apache.cxf.interceptor.Fault;
import org.oasis_open.docs.ebxml_bp.ebbp_signals_2.MessagePartNRInformation;
import org.oasis_open.docs.ebxml_bp.ebbp_signals_2.NonRepudiationInformation;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.Error;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.MessageInfo;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.Receipt;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.SignalMessage;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.UserMessage;
import org.w3.xmldsig.ReferenceType;
import org.w3c.dom.Node;

@Singleton
public class As4MessageFactory {
    private final MessageIdGenerator messageIdGenerator;
    private final MessageFactory messageFactory;
    private final JAXBContext jaxbContext;

    @Inject
    public As4MessageFactory(MessageIdGenerator messageIdGenerator) throws SOAPException {
        this(messageIdGenerator, MessageFactory.newInstance((String)"SOAP 1.2 Protocol"), Marshalling.getInstance());
    }

    public As4MessageFactory(MessageIdGenerator messageIdGenerator, MessageFactory messageFactory, JAXBContext jaxbContext) {
        this.messageFactory = messageFactory;
        this.jaxbContext = jaxbContext;
        this.messageIdGenerator = messageIdGenerator;
    }

    public SOAPMessage createReceiptMessage(UserMessage inUserMessage, ProsessingContext prosessingContext) throws OxalisAs4Exception {
        XMLGregorianCalendar xmlGc = XMLUtil.dateToXMLGeorgianCalendar(prosessingContext.getReceiptTimestamp().getDate());
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setTimestamp(xmlGc);
        messageInfo.setMessageId(this.messageIdGenerator.generate());
        messageInfo.setRefToMessageId(inUserMessage.getMessageInfo().getMessageId());
        List mpList = prosessingContext.getReferenceList().stream().map(reference -> {
            MessagePartNRInformation messagePartNRInformation = new MessagePartNRInformation();
            messagePartNRInformation.setReference((ReferenceType)reference);
            return messagePartNRInformation;
        }).collect(Collectors.toList());
        NonRepudiationInformation nri = new NonRepudiationInformation();
        nri.getMessagePartNRInformation().addAll(mpList);
        Receipt receipt = new Receipt();
        receipt.getAny().add(nri);
        SignalMessage signalMessage = new SignalMessage();
        signalMessage.setMessageInfo(messageInfo);
        signalMessage.setReceipt(receipt);
        return this.marshalSignalMessage(signalMessage);
    }

    public SOAPMessage createErrorMessage(String messageId, AS4Error as4Error) {
        try {
            XMLGregorianCalendar currentDate = XMLUtil.dateToXMLGeorgianCalendar(new Date());
            MessageInfo messageInfo = new MessageInfo();
            messageInfo.setRefToMessageId(messageId);
            messageInfo.setTimestamp(currentDate);
            messageInfo.setMessageId(this.messageIdGenerator.generate());
            Error error = new Error();
            error.setRefToMessageInError(messageId);
            error.setErrorCode(as4Error.getErrorCode().toString());
            error.setErrorDetail(this.getErrorDetail(as4Error));
            error.setShortDescription(as4Error.getErrorCode().getShortDescription());
            error.setOrigin(as4Error.getErrorCode().getOrigin().toString());
            error.setCategory(as4Error.getErrorCode().getCatgory().toString());
            error.setSeverity(as4Error.getSeverity().toString());
            SignalMessage signalMessage = new SignalMessage();
            signalMessage.setMessageInfo(messageInfo);
            signalMessage.getError().add(error);
            return this.marshalSignalMessage(signalMessage);
        }
        catch (OxalisAs4Exception e) {
            throw new Fault(e.getCause());
        }
    }

    private String getErrorDetail(AS4Error as4Error) {
        StringBuilder sb = new StringBuilder();
        sb.append(as4Error.getMessage());
        Throwable throwable = as4Error.getException();
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
            sb.append("\ncause: ").append(throwable.getMessage());
        }
        return sb.toString();
    }

    public SOAPMessage marshalSignalMessage(SignalMessage signalMessage) throws OxalisAs4Exception {
        try {
            SOAPMessage message = this.messageFactory.createMessage();
            SOAPHeader soapHeader = message.getSOAPHeader();
            SOAPHeaderElement messagingHeader = soapHeader.addHeaderElement(Constants.MESSAGING_QNAME);
            messagingHeader.setMustUnderstand(true);
            JAXBElement userMessageJAXBElement = new JAXBElement(Constants.SIGNAL_MESSAGE_QNAME, SignalMessage.class, (Object)signalMessage);
            this.jaxbContext.createMarshaller().marshal((Object)userMessageJAXBElement, (Node)messagingHeader);
            return message;
        }
        catch (Exception e) {
            throw new OxalisAs4Exception("Unable to marshal SignalMessage", e, AS4ErrorCode.EBMS_0004);
        }
    }
}

