/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.as4.inbound;

import jakarta.activation.DataSource;
import org.apache.cxf.attachment.As4AttachmentDataSource;
import org.apache.cxf.attachment.As4AttachmentDeserializer;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

public class AttachmentCleanupInterceptor
extends AbstractPhaseInterceptor<Message> {
    public AttachmentCleanupInterceptor() {
        super("post-invoke");
    }

    public void handleMessage(Message message) throws Fault {
        Exchange exchange = message.getExchange();
        this.cleanRequestAttachment(exchange);
    }

    private void cleanRequestAttachment(Exchange exchange) {
        As4AttachmentDeserializer ad = (As4AttachmentDeserializer)exchange.getInMessage().get(As4AttachmentDeserializer.class);
        ad.getRemoved().forEach(this::close);
    }

    private void close(Attachment attachment) {
        DataSource dataSource = attachment.getDataHandler().getDataSource();
        if (dataSource instanceof As4AttachmentDataSource) {
            As4AttachmentDataSource ads = (As4AttachmentDataSource)dataSource;
            ads.closeAll();
        }
    }
}

