/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.as4.outbound;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import network.oxalis.api.outbound.TransmissionRequest;
import network.oxalis.as4.api.MessageIdGenerator;
import network.oxalis.as4.common.As4MessageProperties;
import network.oxalis.as4.outbound.ActionProvider;
import network.oxalis.as4.outbound.As4TransmissionRequest;
import network.oxalis.as4.util.GeneralUtils;
import network.oxalis.as4.util.PeppolConfiguration;
import network.oxalis.as4.util.TransmissionRequestUtil;
import network.oxalis.commons.security.CertificateUtils;
import network.oxalis.vefa.peppol.common.model.ProcessIdentifier;
import org.apache.cxf.attachment.AttachmentUtil;
import org.apache.cxf.message.Attachment;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.AgreementRef;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.CollaborationInfo;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.From;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.MessageInfo;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.MessageProperties;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.Messaging;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.PartInfo;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.PartProperties;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.PartyId;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.PartyInfo;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.PayloadInfo;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.Property;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.Service;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.To;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.UserMessage;

public class MessagingProvider {
    private final X509Certificate certificate;
    private final MessageIdGenerator messageIdGenerator;
    private final PeppolConfiguration defaultOutboundConfiguration;
    private final ActionProvider actionProvider;

    @Inject
    public MessagingProvider(X509Certificate certificate, MessageIdGenerator messageIdGenerator, PeppolConfiguration defaultOutboundConfiguration, ActionProvider actionProvider) {
        this.certificate = certificate;
        this.messageIdGenerator = messageIdGenerator;
        this.defaultOutboundConfiguration = defaultOutboundConfiguration;
        this.actionProvider = actionProvider;
    }

    public Messaging createMessagingHeader(TransmissionRequest request, Collection<Attachment> attachments) {
        Messaging messaging = new Messaging();
        messaging.getUserMessage().add(this.getUserMessage(request, attachments));
        return messaging;
    }

    public UserMessage getUserMessage(TransmissionRequest request, Collection<Attachment> attachments) {
        UserMessage userMessage = new UserMessage();
        userMessage.setMessageInfo(this.createMessageInfo(request));
        userMessage.setPartyInfo(this.createPartyInfo(request));
        userMessage.setCollaborationInfo(this.createCollaborationInfo(request));
        userMessage.setMessageProperties(this.createMessageProperties(request));
        userMessage.setPayloadInfo(this.createPayloadInfo(request, attachments));
        return userMessage;
    }

    private PayloadInfo createPayloadInfo(TransmissionRequest request, Collection<Attachment> attachments) {
        ArrayList partInfos = Lists.newArrayList();
        for (Attachment attachment : attachments) {
            PartProperties partProperties = new PartProperties();
            String cid = "cid:" + AttachmentUtil.cleanContentId((String)attachment.getId());
            GeneralUtils.iteratorToStreamOfUnknownSize(attachment.getHeaderNames(), 16, false).filter(header -> !"Content-ID".equals(header)).map(header -> {
                Property property = new Property();
                property.setName((String)header);
                property.setValue(attachment.getHeader(header));
                return property;
            }).forEach(partProperties.getProperty()::add);
            if (request instanceof As4TransmissionRequest) {
                Property property;
                As4TransmissionRequest as4TransmissionRequest = (As4TransmissionRequest)request;
                if (null != as4TransmissionRequest.getPayloadCharset()) {
                    property = new Property();
                    property.setName("CharacterSet");
                    property.setValue(as4TransmissionRequest.getPayloadCharset().name().toLowerCase());
                    partProperties.getProperty().add(property);
                }
                if (null != as4TransmissionRequest.getCompressionType()) {
                    property = new Property();
                    property.setName("CompressionType");
                    property.setValue(as4TransmissionRequest.getCompressionType());
                    partProperties.getProperty().add(property);
                }
            }
            PartInfo partInfo = new PartInfo();
            partInfo.setHref(cid);
            partInfo.setPartProperties(partProperties);
            partInfos.add(partInfo);
        }
        PayloadInfo payloadInfo = new PayloadInfo();
        payloadInfo.getPartInfo().addAll(partInfos);
        return payloadInfo;
    }

    private MessageProperties createMessageProperties(TransmissionRequest request) {
        As4TransmissionRequest as4TransmissionRequest;
        As4MessageProperties properties = new As4MessageProperties();
        if (request instanceof As4TransmissionRequest && (as4TransmissionRequest = (As4TransmissionRequest)request).getMessageProperties() != null) {
            properties.addAll(as4TransmissionRequest.getMessageProperties());
        }
        if (properties.isMissing("originalSender")) {
            properties.add(TransmissionRequestUtil.toAs4MessageProperty("originalSender", request.getHeader().getSender()));
        }
        if (properties.isMissing("finalRecipient")) {
            properties.add(TransmissionRequestUtil.toAs4MessageProperty("finalRecipient", request.getHeader().getReceiver()));
        }
        MessageProperties messageProperties = new MessageProperties();
        properties.stream().map(p -> {
            Property property = new Property();
            property.setName(p.getName());
            property.setType(p.getType());
            property.setValue(p.getValue());
            return property;
        }).forEach(messageProperties.getProperty()::add);
        return messageProperties;
    }

    private PartyInfo createPartyInfo(TransmissionRequest request) {
        String fromName = CertificateUtils.extractCommonName((X509Certificate)this.certificate);
        String toName = CertificateUtils.extractCommonName((X509Certificate)request.getEndpoint().getCertificate());
        PeppolConfiguration outboundConfiguration = request.getTag() instanceof PeppolConfiguration ? (PeppolConfiguration)request.getTag() : this.defaultOutboundConfiguration;
        PartyId fromPartyId = new PartyId();
        fromPartyId.setType(outboundConfiguration.getPartyIDType());
        fromPartyId.setValue(fromName);
        From from = new From();
        from.getPartyId().add(fromPartyId);
        from.setRole(outboundConfiguration.getFromRole());
        PartyId toPartyId = new PartyId();
        toPartyId.setType(outboundConfiguration.getPartyIDType());
        toPartyId.setValue(toName);
        To to = new To();
        to.getPartyId().add(toPartyId);
        to.setRole(outboundConfiguration.getToRole());
        PartyInfo partyInfo = new PartyInfo();
        partyInfo.setFrom(from);
        partyInfo.setTo(to);
        return partyInfo;
    }

    public CollaborationInfo createCollaborationInfo(TransmissionRequest request) {
        String action = this.actionProvider.getAction(request.getHeader().getDocumentType());
        ProcessIdentifier process = request.getHeader().getProcess();
        Service service = new Service();
        service.setType(process.getScheme().getIdentifier());
        service.setValue(process.getIdentifier());
        CollaborationInfo ci = new CollaborationInfo();
        ci.setConversationId(this.getConversationId(request));
        ci.setAction(action);
        ci.setService(service);
        if (request instanceof As4TransmissionRequest && ((As4TransmissionRequest)request).isPing()) {
            ci.setAction("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/test");
            Service testActionService = new Service();
            testActionService.setValue("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/service");
            ci.setService(testActionService);
        }
        if (this.defaultOutboundConfiguration.getAgreementRef() != null) {
            AgreementRef agreementRef = new AgreementRef();
            agreementRef.setValue(this.defaultOutboundConfiguration.getAgreementRef());
            ci.setAgreementRef(agreementRef);
        }
        return ci;
    }

    private MessageInfo createMessageInfo(TransmissionRequest request) {
        As4TransmissionRequest as4TransmissionRequest;
        XMLGregorianCalendar xmlDate;
        GregorianCalendar gcal = GregorianCalendar.from(LocalDateTime.now().atZone(ZoneId.systemDefault()));
        try {
            xmlDate = DatatypeFactory.newInstance().newXMLGregorianCalendar(gcal);
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException("Error getting xml date", e);
        }
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setMessageId(this.getMessageId(request));
        messageInfo.setTimestamp(xmlDate);
        if (request instanceof As4TransmissionRequest && (as4TransmissionRequest = (As4TransmissionRequest)request).getRefToMessageId() != null) {
            messageInfo.setRefToMessageId(as4TransmissionRequest.getRefToMessageId());
        }
        return messageInfo;
    }

    private String getMessageId(TransmissionRequest request) {
        String messageId = null;
        if (request instanceof As4TransmissionRequest) {
            As4TransmissionRequest as4TransmissionRequest = (As4TransmissionRequest)request;
            messageId = as4TransmissionRequest.getMessageId();
        }
        return messageId != null ? messageId : this.newId();
    }

    private String getConversationId(TransmissionRequest request) {
        String conversationId = null;
        if (request instanceof As4TransmissionRequest) {
            As4TransmissionRequest as4TransmissionRequest = (As4TransmissionRequest)request;
            conversationId = as4TransmissionRequest.getConversationId();
        }
        return conversationId != null ? conversationId : this.newId();
    }

    private String newId() {
        return this.messageIdGenerator.generate();
    }
}

