/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.as4.outbound;

import com.google.inject.Inject;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.ws.Dispatch;
import jakarta.xml.ws.Service;
import jakarta.xml.ws.WebServiceFeature;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import lombok.Generated;
import network.oxalis.api.outbound.TransmissionRequest;
import network.oxalis.api.outbound.TransmissionResponse;
import network.oxalis.api.settings.Settings;
import network.oxalis.as4.api.MessageIdGenerator;
import network.oxalis.as4.common.MerlinProvider;
import network.oxalis.as4.config.As4Conf;
import network.oxalis.as4.lang.OxalisAs4TransmissionException;
import network.oxalis.as4.outbound.As4TransmissionRequest;
import network.oxalis.as4.outbound.BrowserTypeProvider;
import network.oxalis.as4.outbound.LoggingBeforeSecurityInInterceptor;
import network.oxalis.as4.outbound.MessagingProvider;
import network.oxalis.as4.outbound.TransmissionResponseConverter;
import network.oxalis.as4.util.CompressionUtil;
import network.oxalis.as4.util.Constants;
import network.oxalis.as4.util.PolicyService;
import network.oxalis.commons.http.HttpConf;
import network.oxalis.commons.security.KeyStoreConf;
import org.apache.cxf.attachment.AttachmentUtil;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.ext.logging.LoggingFeature;
import org.apache.cxf.headers.Header;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxws.DispatchImpl;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.ws.policy.WSPolicyFeature;
import org.apache.neethi.Policy;
import org.apache.wss4j.common.crypto.Merlin;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.Messaging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class As4MessageSender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(As4MessageSender.class);
    public static final QName SERVICE_NAME = new QName("oxalis.network/", "outbound-service");
    public static final QName PORT_NAME = new QName("oxalis.network/", "port");
    private final MessagingProvider messagingProvider;
    private final MessageIdGenerator messageIdGenerator;
    private final Settings<KeyStoreConf> settings;
    private final Settings<As4Conf> as4settings;
    private final CompressionUtil compressionUtil;
    private final Settings<HttpConf> httpConfSettings;
    private final TransmissionResponseConverter transmissionResponseConverter;
    private final MerlinProvider merlinProvider;
    private final PolicyService policyService;
    private final String browserType;

    @Inject
    public As4MessageSender(MessagingProvider messagingProvider, MessageIdGenerator messageIdGenerator, Settings<KeyStoreConf> settings, Settings<As4Conf> as4settings, CompressionUtil compressionUtil, Settings<HttpConf> httpConfSettings, TransmissionResponseConverter transmissionResponseConverter, MerlinProvider merlinProvider, PolicyService policyService, BrowserTypeProvider browserTypeProvider) {
        this.messagingProvider = messagingProvider;
        this.messageIdGenerator = messageIdGenerator;
        this.settings = settings;
        this.as4settings = as4settings;
        this.compressionUtil = compressionUtil;
        this.httpConfSettings = httpConfSettings;
        this.transmissionResponseConverter = transmissionResponseConverter;
        this.merlinProvider = merlinProvider;
        this.policyService = policyService;
        this.browserType = browserTypeProvider.getBrowserType();
    }

    public TransmissionResponse send(TransmissionRequest request) throws OxalisAs4TransmissionException {
        AttachmentHolder attachmentHolder = null;
        try {
            TransmissionResponse transmissionResponse;
            block16: {
                DispatchImpl<SOAPMessage> dispatch = this.createDispatch(request);
                try {
                    attachmentHolder = this.prepareAttachment(request);
                    ArrayList<Attachment> attachments = new ArrayList<Attachment>(Collections.singletonList(attachmentHolder.attachment));
                    dispatch.getRequestContext().put(Message.ATTACHMENTS, attachments);
                    Messaging messaging = this.messagingProvider.createMessagingHeader(request, attachments);
                    SoapHeader header = this.getSoapHeader(messaging);
                    dispatch.getRequestContext().put(Header.HEADER_LIST, new ArrayList<SoapHeader>(Collections.singletonList(header)));
                    transmissionResponse = this.invoke(request, dispatch);
                    if (dispatch == null) break block16;
                }
                catch (Throwable throwable) {
                    try {
                        if (dispatch != null) {
                            try {
                                dispatch.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new OxalisAs4TransmissionException("Failed to send message", (Throwable)e);
                    }
                }
                dispatch.close();
            }
            return transmissionResponse;
        }
        finally {
            if (attachmentHolder != null) {
                try {
                    attachmentHolder.inputStream.close();
                }
                catch (IOException e) {
                    log.error("Couldn't close attachment input stream", (Throwable)e);
                }
            }
        }
    }

    private TransmissionResponse invoke(TransmissionRequest request, DispatchImpl<SOAPMessage> dispatch) throws OxalisAs4TransmissionException {
        try {
            SOAPMessage response = (SOAPMessage)dispatch.invoke(null);
            return this.transmissionResponseConverter.convert(request, response);
        }
        catch (Exception e) {
            throw new OxalisAs4TransmissionException("Failed to send message", (Throwable)e);
        }
    }

    private SoapHeader getSoapHeader(Messaging messaging) throws OxalisAs4TransmissionException {
        try {
            JAXBDataBinding binding = new JAXBDataBinding(new Class[]{Messaging.class});
            return new SoapHeader(Constants.MESSAGING_QNAME, (Object)messaging, (DataBinding)binding, true);
        }
        catch (JAXBException e) {
            throw new OxalisAs4TransmissionException("Unable to marshal AS4 header", (Throwable)e);
        }
    }

    private void configureSecurity(TransmissionRequest request, Dispatch<SOAPMessage> dispatch) {
        Merlin merlin = this.merlinProvider.getMerlin();
        dispatch.getRequestContext().put("security.signature.crypto", merlin);
        dispatch.getRequestContext().put("security.signature.password", this.settings.getString((Object)KeyStoreConf.KEY_PASSWORD));
        dispatch.getRequestContext().put("security.signature.username", this.settings.getString((Object)KeyStoreConf.KEY_ALIAS));
        dispatch.getRequestContext().put("security.encryption.certificate", request.getEndpoint().getCertificate());
        dispatch.getRequestContext().put("ws-security.swa.encryption.attachment.transform.content", true);
    }

    public AttachmentHolder prepareAttachment(TransmissionRequest request) throws OxalisAs4TransmissionException {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        headers.put("Content-ID", Collections.singletonList(this.getContentID(request)));
        headers.put("CompressionType", Collections.singletonList("application/gzip"));
        headers.put("MimeType", Collections.singletonList("application/xml"));
        try {
            InputStream compressedStream = this.compressionUtil.getCompressedStream(request.getPayload());
            Attachment attachment = AttachmentUtil.createAttachment((InputStream)compressedStream, headers);
            return new AttachmentHolder(compressedStream, attachment);
        }
        catch (IOException e) {
            throw new OxalisAs4TransmissionException("Unable to compress payload", (Throwable)e);
        }
    }

    private String getContentID(TransmissionRequest request) {
        if (request instanceof As4TransmissionRequest) {
            As4TransmissionRequest as4request = (As4TransmissionRequest)request;
            return as4request.getPayloadHref();
        }
        return this.messageIdGenerator.generate();
    }

    private DispatchImpl<SOAPMessage> createDispatch(TransmissionRequest request) throws OxalisAs4TransmissionException {
        DispatchImpl dispatch = (DispatchImpl)this.getService(request).createDispatch(PORT_NAME, SOAPMessage.class, Service.Mode.MESSAGE);
        dispatch.getRequestContext().put("jakarta.xml.ws.service.endpoint.address", request.getEndpoint().getAddress().toString());
        this.configureSecurity(request, (Dispatch<SOAPMessage>)dispatch);
        Client client = dispatch.getClient();
        if ("cef-conformance".equalsIgnoreCase(this.as4settings.getString((Object)As4Conf.TYPE))) {
            client.getInInterceptors().add(this.getLoggingBeforeSecurityInInterceptor());
        }
        HTTPConduit httpConduit = (HTTPConduit)client.getConduit();
        HTTPClientPolicy httpClientPolicy = httpConduit.getClient();
        httpClientPolicy.setConnectionTimeout((long)this.httpConfSettings.getInt((Object)HttpConf.TIMEOUT_CONNECT));
        httpClientPolicy.setReceiveTimeout((long)this.httpConfSettings.getInt((Object)HttpConf.TIMEOUT_READ));
        httpClientPolicy.setVersion(this.httpConfSettings.getString((Object)HttpConf.HTTP_VERSION));
        httpClientPolicy.setAllowChunking(true);
        httpClientPolicy.setChunkLength(8192);
        httpClientPolicy.setBrowserType(this.browserType);
        httpConduit.setClient(httpClientPolicy);
        return dispatch;
    }

    private LoggingBeforeSecurityInInterceptor getLoggingBeforeSecurityInInterceptor() {
        LoggingBeforeSecurityInInterceptor interceptor = new LoggingBeforeSecurityInInterceptor();
        interceptor.setPrettyLogging(true);
        interceptor.setLogMultipart(true);
        return interceptor;
    }

    private Service getService(TransmissionRequest request) throws OxalisAs4TransmissionException {
        Service service = Service.create((QName)SERVICE_NAME, (WebServiceFeature[])new WebServiceFeature[]{new LoggingFeature(), new WSPolicyFeature(new Policy[]{this.policyService.getPolicy(request)})});
        service.addPort(PORT_NAME, "http://www.w3.org/2003/05/soap/bindings/HTTP/", request.getEndpoint().getAddress().toString());
        return service;
    }

    private static class AttachmentHolder {
        private final InputStream inputStream;
        private final Attachment attachment;

        @Generated
        public AttachmentHolder(InputStream inputStream, Attachment attachment) {
            this.inputStream = inputStream;
            this.attachment = attachment;
        }
    }
}

