/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.as4.inbound;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import lombok.Generated;
import network.oxalis.api.settings.Settings;
import network.oxalis.as4.common.MerlinProvider;
import network.oxalis.as4.inbound.As4EndpointsPublisher;
import network.oxalis.commons.security.KeyStoreConf;
import org.apache.cxf.BusFactory;
import org.apache.cxf.ext.logging.LoggingFeature;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.transport.servlet.CXFNonSpringServlet;
import org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JInInterceptor;
import org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JOutInterceptor;
import org.apache.wss4j.common.crypto.Merlin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class As4Servlet
extends CXFNonSpringServlet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(As4Servlet.class);
    @Inject
    private Settings<KeyStoreConf> settings;
    @Inject
    private As4EndpointsPublisher endpointsPublisher;
    @Inject
    private MerlinProvider merlinProvider;

    protected void loadBus(ServletConfig servletConfig) {
        this.bus = BusFactory.getThreadDefaultBus();
        EndpointImpl endpointImpl = this.endpointsPublisher.publish(this.getBus());
        Merlin merlin = this.merlinProvider.getMerlin();
        endpointImpl.getProperties().put("security.signature.crypto", merlin);
        endpointImpl.getProperties().put("security.signature.password", this.settings.getString((Object)KeyStoreConf.KEY_PASSWORD));
        endpointImpl.getProperties().put("security.signature.username", this.settings.getString((Object)KeyStoreConf.KEY_ALIAS));
        endpointImpl.getProperties().put("security.encryption.crypto", merlin);
        endpointImpl.getProperties().put("security.encryption.username", this.settings.getString((Object)KeyStoreConf.KEY_ALIAS));
        endpointImpl.getInInterceptors().add(new PolicyBasedWSS4JInInterceptor());
        endpointImpl.getOutInterceptors().add(new PolicyBasedWSS4JOutInterceptor());
        endpointImpl.getFeatures().add(new LoggingFeature());
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            response.setStatus(200);
            response.getWriter().write("Hello AS4 world\n");
        }
        catch (IOException e) {
            throw new ServletException("Unable to send response", (Throwable)e);
        }
    }
}

