/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.commons.http;

import com.google.inject.Provides;
import com.google.inject.Singleton;
import io.opentracing.Tracer;
import io.opentracing.contrib.apache.http.client.TracingHttpClientBuilder;
import network.oxalis.api.settings.Settings;
import network.oxalis.commons.guice.OxalisModule;
import network.oxalis.commons.http.HttpConf;
import network.oxalis.commons.util.OxalisVersion;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class ApacheHttpModule
extends OxalisModule {
    private static final String USER_AGENT = String.format("Oxalis %s", OxalisVersion.getVersion());

    protected void configure() {
        this.bindSettings(HttpConf.class);
    }

    @Provides
    @Singleton
    protected PoolingHttpClientConnectionManager getPoolingHttpClientConnectionManager(Settings<HttpConf> settings) {
        PoolingHttpClientConnectionManager httpClientConnectionManager = new PoolingHttpClientConnectionManager();
        httpClientConnectionManager.setDefaultMaxPerRoute(settings.getInt((Object)HttpConf.POOL_MAX_ROUTE));
        httpClientConnectionManager.setMaxTotal(settings.getInt((Object)HttpConf.POOL_TOTAL));
        return httpClientConnectionManager;
    }

    @Provides
    @Singleton
    protected RequestConfig getRequestConfig(Settings<HttpConf> settings) {
        return RequestConfig.custom().setConnectTimeout(settings.getInt((Object)HttpConf.TIMEOUT_CONNECT)).setConnectionRequestTimeout(settings.getInt((Object)HttpConf.TIMEOUT_READ)).setSocketTimeout(settings.getInt((Object)HttpConf.TIMEOUT_SOCKET)).build();
    }

    @Provides
    protected CloseableHttpClient getHttpClient(PoolingHttpClientConnectionManager connectionManager, RequestConfig requestConfig, Tracer tracer) {
        TracingHttpClientBuilder httpClientBuilder = new TracingHttpClientBuilder().withTracer(tracer);
        httpClientBuilder.setUserAgent(USER_AGENT);
        httpClientBuilder.setDefaultRequestConfig(requestConfig);
        httpClientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager);
        httpClientBuilder.setConnectionManagerShared(true);
        httpClientBuilder.useSystemProperties();
        return httpClientBuilder.build();
    }
}

