/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.commons.settings;

import com.google.inject.Inject;
import com.typesafe.config.Config;
import java.lang.reflect.Field;
import java.util.Map;
import network.oxalis.api.lang.OxalisLoadingException;
import network.oxalis.api.settings.DefaultValue;
import network.oxalis.api.settings.Nullable;
import network.oxalis.api.settings.Settings;

class TypesafeSettings<T>
implements Settings<T> {
    private final Config config;
    private final Map<T, String> settings;

    @Inject
    public TypesafeSettings(Config config, Map<T, String> settings) {
        this.config = config;
        this.settings = settings;
    }

    public String getString(T key) {
        if (this.config.hasPath(this.settings.get(key))) {
            return this.config.getString(this.settings.get(key));
        }
        Field field = TypesafeSettings.getField(key);
        if (field.getAnnotation(Nullable.class) != null) {
            return null;
        }
        if (field.getAnnotation(DefaultValue.class) != null) {
            return field.getAnnotation(DefaultValue.class).value();
        }
        throw new OxalisLoadingException(String.format("Setting '%s' not found.", this.settings.get(key)));
    }

    public int getInt(T key) {
        if (this.config.hasPath(this.settings.get(key))) {
            return this.config.getInt(this.settings.get(key));
        }
        return Integer.parseInt(this.getString(key));
    }

    protected static <T> Field getField(T key) {
        try {
            return key.getClass().getField(((Enum)key).name());
        }
        catch (NoSuchFieldException e) {
            throw new OxalisLoadingException(e.getMessage(), (Throwable)e);
        }
    }
}

