/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.commons.mode;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import io.opentracing.contrib.apache.http.client.Constants;
import io.opentracing.contrib.spanmanager.DefaultSpanManager;
import io.opentracing.contrib.spanmanager.SpanManager;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.cert.CRLException;
import java.security.cert.X509CRL;
import javax.inject.Named;
import network.oxalis.commons.certvalidator.api.CertificateValidationException;
import network.oxalis.commons.certvalidator.api.CrlCache;
import network.oxalis.commons.certvalidator.util.CrlUtils;
import network.oxalis.commons.certvalidator.util.SimpleCachingCrlFetcher;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

@Singleton
public class OxalisCrlFetcher
extends SimpleCachingCrlFetcher {
    @Inject
    private Provider<CloseableHttpClient> httpClientProvider;
    @Inject
    @Named(value="certificate")
    private RequestConfig requestConfig;

    @Inject
    public OxalisCrlFetcher(CrlCache crlCache) {
        super(crlCache);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected X509CRL httpDownload(String url) throws CertificateValidationException {
        try {
            SpanManager.ManagedSpan span = DefaultSpanManager.getInstance().current();
            BasicHttpContext basicHttpContext = new BasicHttpContext();
            if (span.getSpan() != null) {
                basicHttpContext.setAttribute(Constants.PARENT_CONTEXT, (Object)span.getSpan().context());
            }
            HttpGet httpGet = new HttpGet(URI.create(url));
            httpGet.setConfig(this.requestConfig);
            try (CloseableHttpResponse response = ((CloseableHttpClient)this.httpClientProvider.get()).execute((HttpUriRequest)httpGet, (HttpContext)basicHttpContext);){
                X509CRL crl = CrlUtils.load((InputStream)response.getEntity().getContent());
                this.crlCache.set(url, crl);
                X509CRL x509CRL = crl;
                return x509CRL;
            }
        }
        catch (IOException | CRLException e) {
            throw new CertificateValidationException(String.format("Failed to download CRL '%s' (%s)", url, e.getMessage()), (Throwable)e);
        }
    }
}

