/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.commons.tracing;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Names;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.sdk.trace.SpanProcessor;
import java.lang.annotation.Annotation;
import network.oxalis.api.settings.Settings;
import network.oxalis.commons.guice.ImplLoader;
import network.oxalis.commons.guice.OxalisModule;
import network.oxalis.commons.tracing.NoopSpanProcessorProvider;
import network.oxalis.commons.tracing.OpenTelemetryConf;
import network.oxalis.commons.tracing.OpenTelemetryTracerProvider;
import network.oxalis.commons.tracing.Slf4jSpanProcessor;
import network.oxalis.commons.tracing.SpanManager;
import network.oxalis.commons.tracing.SpanManagerImpl;
import network.oxalis.commons.util.OpenTelemetryUtils;

public class TracingModule
extends OxalisModule {
    protected void configure() {
        this.bindSettings(OpenTelemetryConf.class);
        this.bind(Key.get(SpanProcessor.class, (Annotation)Names.named((String)"noop"))).toProvider(NoopSpanProcessorProvider.class);
        this.bind(Key.get(SpanProcessor.class, (Annotation)Names.named((String)"slf4j"))).to(Slf4jSpanProcessor.class);
        this.bind(Key.get(Tracer.class)).toProvider(OpenTelemetryTracerProvider.class);
        this.bind(Key.get(SpanManager.class)).to(SpanManagerImpl.class);
    }

    @Provides
    @Singleton
    protected SpanProcessor getSpanProcessor(Injector injector, Settings<OpenTelemetryConf> settings) {
        return ImplLoader.get(injector, SpanProcessor.class, settings, OpenTelemetryConf.SPAN_PROCESSOR);
    }

    @Provides
    @Singleton
    protected OpenTelemetry openTelemetry(SpanProcessor spanProcessor) {
        return OpenTelemetryUtils.initOpenTelemetry(spanProcessor);
    }
}

