/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.commons.header;

import com.google.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import network.oxalis.api.header.HeaderParser;
import network.oxalis.api.lang.OxalisContentException;
import network.oxalis.api.util.Type;
import network.oxalis.vefa.peppol.common.model.Header;
import network.oxalis.vefa.peppol.sbdh.SbdReader;
import network.oxalis.vefa.peppol.sbdh.lang.SbdhException;

@Type(value={"sbdh"})
@Singleton
public class SbdhHeaderParser
implements HeaderParser {
    public Header parse(InputStream inputStream) throws OxalisContentException {
        Header header;
        block8: {
            SbdReader sbdReader = SbdReader.newInstance((InputStream)inputStream);
            try {
                header = sbdReader.getHeader();
                if (sbdReader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (sbdReader != null) {
                        try {
                            sbdReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | SbdhException e) {
                    throw new OxalisContentException(e.getMessage(), e);
                }
            }
            sbdReader.close();
        }
        return header;
    }
}

