/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.commons.logging;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.File;
import java.nio.file.Path;
import lombok.Generated;
import network.oxalis.api.logging.Configurator;
import network.oxalis.api.settings.Settings;
import network.oxalis.commons.logging.LoggingConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogbackConfigurator
implements Configurator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogbackConfigurator.class);
    private final Settings<LoggingConf> settings;
    private final Path confPath;

    @Inject
    public LogbackConfigurator(Settings<LoggingConf> settings, @Named(value="conf") Path confPath) {
        this.settings = settings;
        this.confPath = confPath;
    }

    public void execute() {
        File file = this.settings.getPath((Object)LoggingConf.CONFIG, this.confPath).toFile();
        System.out.println("Configuring Logback with configuration: " + file.getAbsolutePath());
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)loggerContext);
        loggerContext.reset();
        try {
            configurator.doConfigure(file);
        }
        catch (JoranException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)loggerContext);
    }
}

