/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.as2.model;

import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Objects;
import network.oxalis.as2.util.SMimeDigestMethod;
import network.oxalis.vefa.peppol.common.model.Digest;

public class Mic {
    private final String digestAsString;
    private final SMimeDigestMethod algorithm;

    public Mic(Digest digest) {
        this(Base64.getEncoder().encodeToString(digest.getValue()), SMimeDigestMethod.findByDigestMethod(digest.getMethod()));
    }

    public Mic(String digestAsString, SMimeDigestMethod algorithm) {
        this.digestAsString = digestAsString;
        this.algorithm = algorithm;
    }

    public static Mic valueOf(String receivedContentMic) throws NoSuchAlgorithmException {
        String[] s2 = receivedContentMic.split(",");
        if (s2.length != 2) {
            throw new IllegalArgumentException("Invalid mic: '" + receivedContentMic + "'. Required syntax: encoded-message-digest \",\" (sha1|md5)");
        }
        return new Mic(s2[0].trim(), SMimeDigestMethod.findByIdentifier(s2[1].trim()));
    }

    public String toString() {
        return String.format("%s, %s", this.digestAsString, this.algorithm.getIdentifier());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Mic mic = (Mic)o;
        return Objects.equals(this.digestAsString, mic.digestAsString) && this.algorithm == mic.algorithm;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.digestAsString, this.algorithm});
    }
}

