/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.as2.model;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import network.oxalis.as2.util.SMimeDigestMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class As2DispositionNotificationOptions {
    private static final Logger log = LoggerFactory.getLogger(As2DispositionNotificationOptions.class);
    private static final Pattern PATTERN = Pattern.compile("(signed-receipt-protocol|signed-receipt-micalg)\\s*=\\s*(required|optional)\\s*,\\s*([^;]*)");
    private final List<Parameter> parameters;

    public static As2DispositionNotificationOptions getDefault(SMimeDigestMethod digestMethod) {
        return As2DispositionNotificationOptions.valueOf("signed-receipt-protocol=required,pkcs7-signature; signed-receipt-micalg=required," + digestMethod.getIdentifier());
    }

    public static As2DispositionNotificationOptions valueOf(String s) {
        if (s == null) {
            throw new IllegalArgumentException("Can not parse empty disposition-notification-options.");
        }
        ArrayList<Parameter> parameterList = new ArrayList<Parameter>();
        log.debug("Inspecting " + s);
        Matcher matcher = PATTERN.matcher(s);
        while (matcher.find()) {
            if (matcher.groupCount() != 3) {
                throw new IllegalStateException("Internal error: Invalid group count in RegEx for parameter match in disposition-notification-options.");
            }
            String attributeName = matcher.group(1);
            String importanceName = matcher.group(2);
            String value = matcher.group(3);
            Attribute attribute = Attribute.fromString(attributeName);
            Importance importance = Importance.valueOf(importanceName.trim().toUpperCase());
            Parameter parameter = Parameter.of(attribute, importance, value);
            parameterList.add(parameter);
        }
        if (parameterList.isEmpty()) {
            throw new IllegalArgumentException("Unable to create " + As2DispositionNotificationOptions.class.getSimpleName() + " from '" + s + "'");
        }
        return new As2DispositionNotificationOptions(parameterList);
    }

    public As2DispositionNotificationOptions(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    private Parameter getParameterFor(Attribute attribute) {
        for (Parameter parameter : this.parameters) {
            if (parameter.attribute != attribute) continue;
            return parameter;
        }
        return null;
    }

    public Parameter getSignedReceiptMicalg() {
        return this.getParameterFor(Attribute.SIGNED_RECEIPT_MICALG);
    }

    public String getPreferredSignedReceiptMicAlgorithmName() {
        String preferredAlgorithm = "" + this.getSignedReceiptMicalg().getTextValue();
        return preferredAlgorithm.split(",")[0].trim();
    }

    public Parameter getSignedReceiptProtocol() {
        return this.getParameterFor(Attribute.SIGNED_RECEIPT_PROTOCOL);
    }

    public String toString() {
        return String.format("%s; %s", this.getSignedReceiptProtocol(), this.getSignedReceiptMicalg());
    }

    static enum Importance {
        REQUIRED,
        OPTIONAL;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    static enum Attribute {
        SIGNED_RECEIPT_PROTOCOL("signed-receipt-protocol"),
        SIGNED_RECEIPT_MICALG("signed-receipt-micalg");

        private final String text;

        private Attribute(String text) {
            this.text = text;
        }

        static Attribute fromString(String s) {
            if (s == null) {
                throw new IllegalArgumentException("String value required");
            }
            for (Attribute attribute : Attribute.values()) {
                if (!attribute.text.equalsIgnoreCase(s)) continue;
                return attribute;
            }
            throw new IllegalArgumentException(s + " not recognized as an attribute of As2DispositionNotificationOptions");
        }

        public String toString() {
            return this.text;
        }
    }

    static class Parameter {
        Attribute attribute;
        Importance importance;
        String textValue;

        Attribute getAttribute() {
            return this.attribute;
        }

        Importance getImportance() {
            return this.importance;
        }

        String getTextValue() {
            return this.textValue;
        }

        public static Parameter of(Attribute attribute, Importance importance, String textValue) {
            return new Parameter(attribute, importance, textValue);
        }

        Parameter(Attribute attribute, Importance importance, String textValue) {
            this.attribute = attribute;
            this.importance = importance;
            this.textValue = textValue;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("").append((Object)this.attribute).append("=").append((Object)this.importance).append(",").append(this.textValue);
            return sb.toString();
        }
    }
}

