/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.commons.tracing;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import io.opentracing.Tracer;
import io.opentracing.noop.NoopTracerFactory;
import java.lang.annotation.Annotation;
import network.oxalis.api.settings.Settings;
import network.oxalis.commons.guice.ImplLoader;
import network.oxalis.commons.guice.OxalisModule;
import network.oxalis.commons.tracing.BraveConf;
import network.oxalis.commons.tracing.BraveTracerProvider;
import network.oxalis.commons.tracing.Slf4jReporter;
import network.oxalis.commons.tracing.TracingConf;
import zipkin2.reporter.AsyncReporter;
import zipkin2.reporter.Reporter;
import zipkin2.reporter.Sender;
import zipkin2.reporter.urlconnection.URLConnectionSender;

public class TracingModule
extends OxalisModule {
    protected void configure() {
        this.bindSettings(BraveConf.class);
        this.bindSettings(TracingConf.class);
        this.bind(Key.get(Tracer.class, (Annotation)Names.named((String)"noop"))).toProvider(NoopTracerFactory::create);
        this.bind(Key.get(Tracer.class, (Annotation)Names.named((String)"brave"))).toProvider(BraveTracerProvider.class);
        this.bind(Key.get(Reporter.class, (Annotation)Names.named((String)"console"))).toProvider(() -> Reporter.CONSOLE);
        this.bindTyped(Reporter.class, Slf4jReporter.class);
    }

    @Provides
    @Singleton
    @Named(value="http")
    protected Reporter getHttpReporter(Settings<BraveConf> settings) {
        return AsyncReporter.builder((Sender)URLConnectionSender.create((String)settings.getString((Object)BraveConf.HTTP))).build();
    }

    @Provides
    @Singleton
    protected Reporter getReporter(Injector injector, Settings<BraveConf> settings) {
        return ImplLoader.get(injector, Reporter.class, settings, BraveConf.REPORTER);
    }

    @Provides
    @Singleton
    protected Tracer getTracer(Injector injector, Settings<TracingConf> settings) {
        return ImplLoader.get(injector, Tracer.class, settings, TracingConf.TRACER);
    }
}

