/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.common.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import network.oxalis.vefa.peppol.common.api.SimpleEndpoint;
import network.oxalis.vefa.peppol.common.lang.EndpointNotFoundException;
import network.oxalis.vefa.peppol.common.model.DocumentTypeIdentifier;
import network.oxalis.vefa.peppol.common.model.ParticipantIdentifier;
import network.oxalis.vefa.peppol.common.model.ProcessIdentifier;
import network.oxalis.vefa.peppol.common.model.ProcessMetadata;
import network.oxalis.vefa.peppol.common.model.TransportProfile;

public abstract class AbstractServiceMetadata<T extends SimpleEndpoint>
implements Serializable {
    private static final long serialVersionUID = -7523336374349545534L;
    private final ParticipantIdentifier participantIdentifier;
    private final DocumentTypeIdentifier documentTypeIdentifier;
    private final List<ProcessMetadata<T>> processes;

    protected AbstractServiceMetadata(ParticipantIdentifier participantIdentifier, DocumentTypeIdentifier documentTypeIdentifier, List<ProcessMetadata<T>> processes) {
        this.participantIdentifier = participantIdentifier;
        this.documentTypeIdentifier = documentTypeIdentifier;
        this.processes = processes;
    }

    public ParticipantIdentifier getParticipantIdentifier() {
        return this.participantIdentifier;
    }

    public DocumentTypeIdentifier getDocumentTypeIdentifier() {
        return this.documentTypeIdentifier;
    }

    public List<ProcessMetadata<T>> getProcesses() {
        return Collections.unmodifiableList(this.processes);
    }

    public T getEndpoint(ProcessIdentifier processIdentifier, TransportProfile ... transportProfiles) throws EndpointNotFoundException {
        for (ProcessMetadata<T> processMetadata : this.processes) {
            if (!processMetadata.getProcessIdentifier().contains(processIdentifier)) continue;
            return processMetadata.getEndpoint(transportProfiles);
        }
        throw new EndpointNotFoundException(String.format("Combination of '%s' and transport profile(s) not found.", processIdentifier));
    }
}

