/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.common.model;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import network.oxalis.vefa.peppol.common.model.DocumentTypeIdentifier;
import network.oxalis.vefa.peppol.common.model.ProcessIdentifier;

public class ServiceReference {
    private DocumentTypeIdentifier documentTypeIdentifier;
    private List<ProcessIdentifier> processIdentifiers;

    public static ServiceReference of(DocumentTypeIdentifier documentTypeIdentifier, ProcessIdentifier ... processIdentifiers) {
        return new ServiceReference(documentTypeIdentifier, Arrays.asList(processIdentifiers));
    }

    public static ServiceReference of(DocumentTypeIdentifier documentTypeIdentifier, List<ProcessIdentifier> processIdentifiers) {
        return new ServiceReference(documentTypeIdentifier, processIdentifiers);
    }

    private ServiceReference(DocumentTypeIdentifier documentTypeIdentifier, List<ProcessIdentifier> processIdentifiers) {
        this.documentTypeIdentifier = documentTypeIdentifier;
        this.processIdentifiers = processIdentifiers;
    }

    public DocumentTypeIdentifier getDocumentTypeIdentifier() {
        return this.documentTypeIdentifier;
    }

    public List<ProcessIdentifier> getProcessIdentifiers() {
        return this.processIdentifiers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceReference that = (ServiceReference)o;
        return Objects.equals(this.documentTypeIdentifier, that.documentTypeIdentifier) && Objects.equals(this.processIdentifiers, that.processIdentifiers);
    }

    public int hashCode() {
        return Objects.hash(this.documentTypeIdentifier, this.processIdentifiers);
    }
}

